% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simode.R
\docType{data}
\name{sir_example}
\alias{sir_example}
\title{Example dataset for a multi-group SIR model}
\format{
A list containing the following variables:
\describe{
  \item{equations}{The ODE equations describing the system, including
  ten equations for the susceptible dynamics (2 groups * 5 seasons) and
  ten equations for the infected dynamics.}
  \item{beta}{The 2x2 transmission matrix parameters (in time unit of weeks).}
  \item{gamma}{The recovery rate parameter (in time unit of weeks).}
  \item{kappa}{The relative infectiousness of seasons 2-5 compared to season 1.}
  \item{S0}{The initial conditions for the susceptible variables.}
  \item{I0}{The initial conditions for the infected variables.}
  \item{time}{Times in which the observations were made (in weeks).}
  \item{obs}{A list of observations of the infected variables,
  generated using Gaussian measurement error with sigma=1e-3.}
}
}
\usage{
sir_example
}
\description{
A model for the spread of a seasonal influenza epidemics in two groups
over five seasons.
}
\keyword{datasets}
