% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{SparseGroupPLS}
\alias{SparseGroupPLS}
\title{Sparse group Partial Least Squares}
\usage{
SparseGroupPLS(
  xdata,
  ydata,
  family = "gaussian",
  group_x,
  group_y = NULL,
  Lambda,
  alpha.x,
  alpha.y = NULL,
  keepX_previous = NULL,
  keepY = NULL,
  ncomp = 1,
  scale = TRUE,
  ...
)
}
\arguments{
\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}

\item{family}{type of PLS model. If \code{family="gaussian"}, a sparse group
PLS model as defined in \code{\link[sgPLS]{sgPLS}} is run (for continuous
outcomes). If \code{family="binomial"}, a PLS-DA model as defined in
\code{\link[sgPLS]{sgPLSda}} is run (for categorical outcomes).}

\item{group_x}{vector encoding the grouping structure among predictors. This
argument indicates the number of variables in each group.}

\item{group_y}{optional vector encoding the grouping structure among
outcomes. This argument indicates the number of variables in each group.}

\item{Lambda}{matrix of parameters controlling the number of selected groups
at current component, as defined by \code{ncomp}.}

\item{alpha.x}{vector of parameters controlling the level of sparsity within
groups of predictors.}

\item{alpha.y}{optional vector of parameters controlling the level of
sparsity within groups of outcomes. Only used if \code{family="gaussian"}.}

\item{keepX_previous}{number of selected groups in previous components. Only
used if \code{ncomp > 1}. The argument \code{keepX} in
\code{\link[sgPLS]{sgPLS}} is obtained by concatenating
\code{keepX_previous} and \code{Lambda}.}

\item{keepY}{number of selected groups of outcome variables. This argument is
defined as in \code{\link[sgPLS]{sgPLS}}. Only used if
\code{family="gaussian"}.}

\item{ncomp}{number of components.}

\item{scale}{logical indicating if the data should be scaled (i.e.
transformed so that all variables have a standard deviation of one). Only
used if \code{family="gaussian"}.}

\item{...}{additional arguments to be passed to \code{\link[sgPLS]{sgPLS}} or
\code{\link[sgPLS]{sgPLSda}}.}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different model parameters. Columns correspond to
  predictors.} \item{beta_full}{array of model coefficients. Rows correspond
  to different model parameters. Columns correspond to predictors (starting
  with "X") or outcomes (starting with "Y") variables for different
  components (denoted by "PC").}
}
\description{
Runs a sparse group Partial Least Squares model using implementation from
\code{\link[sgPLS]{sgPLS-package}}. This function is not using stability.
}
\examples{
## Sparse group PLS
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 30, q = 3, family = "gaussian")
x <- simul$xdata
y <- simul$ydata

# Running sgPLS with 1 group and sparsity of 0.5
mypls <- SparseGroupPLS(
  xdata = x, ydata = y, Lambda = 1, family = "gaussian",
  group_x = c(10, 15, 5), alpha.x = 0.5
)

# Running sgPLS with groups on outcomes
mypls <- SparseGroupPLS(
  xdata = x, ydata = y, Lambda = 1, family = "gaussian",
  group_x = c(10, 15, 5), alpha.x = 0.5,
  group_y = c(2, 1), keepY = 1, alpha.y = 0.9
)

## Sparse group PLS-DA
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, family = "binomial")

# Running sgPLS-DA with 1 group and sparsity of 0.9
mypls <- SparseGroupPLS(
  xdata = simul$xdata, ydata = simul$ydata, Lambda = 1, family = "binomial",
  group_x = c(10, 15, 25), alpha.x = 0.9
)
}
\references{
\insertRef{sparsegroupPLS}{sharp}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{BiSelection}}

Other penalised dimensionality reduction functions: 
\code{\link{GroupPLS}()},
\code{\link{SparsePCA}()},
\code{\link{SparsePLS}()}
}
\concept{penalised dimensionality reduction functions}
