% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{CalibrationCurve}
\alias{CalibrationCurve}
\title{Calibration curve (internal)}
\usage{
CalibrationCurve(
  stability,
  bty = "o",
  xlab = NULL,
  ylab = NULL,
  cex.axis = 1,
  cex.lab = 1.5,
  cex.legend = 1.2,
  pch = 19,
  lines = TRUE,
  col = NULL,
  legend = TRUE,
  ncol = 1
)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}},
\code{\link{GraphicalModel}} or \code{\link{BiSelection}}.}

\item{bty}{character string indicating if the box around the plot should be
drawn. Possible values include: \code{"o"} (default, the box is drawn), or
\code{"n"} (no box).}

\item{xlab}{label of the x-axis.}

\item{ylab}{label of the y-axis.}

\item{cex.axis}{font size for axes.}

\item{cex.lab}{font size for labels.}

\item{cex.legend}{font size for text legend entries.}

\item{pch}{type of point, as in \code{\link[graphics]{points}}.}

\item{lines}{logical indicating if the points should be linked by lines. Only
used if \code{stability} is the output of \code{\link{BiSelection}}.}

\item{col}{vector of colours.}

\item{legend}{logical indicating if the legend should be included.}

\item{ncol}{integer indicating the number of columns in the legend.}
}
\value{
a calibration curve.
}
\description{
Creates a calibration curve for consensus clustering.
}
\keyword{internal}
