% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-check-helpers.R
\name{check_quantiles}
\alias{check_quantiles}
\title{Check that quantiles are valid}
\usage{
check_quantiles(quantiles, name = "quantiles", range = c(0, 1))
}
\arguments{
\item{quantiles}{Numeric vector of quantiles to check}

\item{name}{Character name to use in error messages}

\item{range}{Numeric vector giving allowed range}
}
\value{
None. Function errors if quantiles are invalid.
}
\description{
Helper function to check that input quantiles are valid.
Quantiles must be in the range specified, increase monotonically,
and contain no duplicates.

This is used in \code{\link[=bias_range]{bias_range()}} and \code{\link[=bias_quantile]{bias_quantile()}} to
provide informative errors to users.
}
\keyword{internal}
