% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Features.liger}
\alias{Features.liger}
\title{Extract Features from LIGER Object}
\usage{
\method{Features}{liger}(x, by_dataset = FALSE, ...)
}
\arguments{
\item{x}{LIGER object name.}

\item{by_dataset}{logical, whether to return list with vector of features for each dataset in
LIGER object or to return single vector of unique features across all datasets in object
(default is FALSE; return vector of unique features)}

\item{...}{Arguments passed to other methods}
}
\value{
vector or list depending on \code{by_dataset} parameter
}
\description{
Extract all unique features from LIGER object
}
\examples{
\dontrun{
# return single vector of all unique features
all_features <- Features(x = object, by_dataset = FALSE)

# return list of vectors containing features from each individual dataset in object
dataset_features <- Features(x = object, by_dataset = TRUE)
}

}
\concept{liger_object_util}
