% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Conversion.R
\name{Convert_Assay}
\alias{Convert_Assay}
\title{Convert between Seurat Assay types}
\usage{
Convert_Assay(seurat_object, assay = NULL, convert_to)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{assay}{name(s) of assays to convert.  Default is NULL and will check with users
which assays they want to convert.}

\item{convert_to}{value of what assay type to convert current assays to.
#' \itemize{
\item Accepted values for V3/4 are: "Assay", "assay", "V3", or "v3".
\item Accepted values for V5 are: "Assay5", "assay5", "V5", or "v5".
}}
}
\description{
Will convert assays within a Seurat object between "Assay" and "Assay5" types.
}
\examples{
\dontrun{
# Convert to V3/4 assay
obj <- Convert_Assay(seurat_object = obj, convert_to = "V3")

# Convert to 5 assay
obj <- Convert_Assay(seurat_object = obj, convert_to = "V5")
}

}
\concept{object_conversion}
