% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{slice}
\alias{slice}
\alias{[,RsparseMatrix,index,index,logical-method}
\alias{[,RsparseMatrix,missing,index,logical-method}
\alias{[,RsparseMatrix,index,missing,logical-method}
\alias{[,RsparseMatrix,missing,missing,logical-method}
\title{CSR Matrices Slicing}
\usage{
\S4method{[}{RsparseMatrix,index,index,logical}(x, i, j, drop = TRUE)

\S4method{[}{RsparseMatrix,missing,index,logical}(x, i, j, drop = TRUE)

\S4method{[}{RsparseMatrix,index,missing,logical}(x, i, j, drop = TRUE)

\S4method{[}{RsparseMatrix,missing,missing,logical}(x, i, j, drop = TRUE)
}
\arguments{
\item{x}{input \code{RsparseMatrix}}

\item{i}{row indices to subset}

\item{j}{column indices to subset}

\item{drop}{whether to simplify 1d matrix to a vector}
}
\value{
A \code{RsparseMatrix}
}
\description{
natively slice CSR matrices without converting them to triplet/CSC
}
\examples{
library(Matrix)
library(rsparse)
# dgCMatrix - CSC
m = rsparsematrix(20, 20, 0.1)
# make CSR
m = as(m, "RsparseMatrix")
inherits(m[1:2, ], "RsparseMatrix")
inherits(m[1:2, 3:4], "RsparseMatrix")
}
