% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_CDSseq.R
\name{refseq_CDSseq}
\alias{refseq_CDSseq}
\title{Extract the CDS nucleotide sequence into a Biostrings object}
\usage{
refseq_CDSseq(transcript)
}
\arguments{
\item{transcript}{A character string of the single/multiple transcript id.}
}
\value{
An object of \code{DNAStringSet} class.
}
\description{
\code{refseq_CDSseq()} Parses a single/multiple transcript accessions (RefSeq format) and extract
the CDS nucleotide sequences into a \code{DNAStringSet} object.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
\donttest{
transcript <-  c("XM_004487701", "XM_004488493", "XM_004501904")
my_cds <- refseq_CDSseq(transcript)
# Now, the `DNAStringSet` can easily used to make a fasta file :
# writeXStringSet(x= my_cds, filepath = "cds_result")}

}
\seealso{
\code{\link{refseq_CDScoords}}
}
\author{
Jose V. Die
}
