% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsEventMethods.R, R/exportEvents.R,
%   R/importEvents.R, R/deleteEvents.R
\name{eventsMethods}
\alias{eventsMethods}
\alias{exportEvents}
\alias{importEvents}
\alias{deleteEvents}
\alias{exportEvents.redcapApiConnection}
\alias{importEvents.redcapApiConnection}
\alias{deleteEvents.redcapApiConnection}
\title{Export, Import, and Delete Event Settings}
\usage{
exportEvents(rcon, ...)

importEvents(rcon, data, override = FALSE, ...)

deleteEvents(rcon, events = NULL, ...)

\method{exportEvents}{redcapApiConnection}(
  rcon,
  arms = NULL,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{importEvents}{redcapApiConnection}(
  rcon,
  data,
  override = FALSE,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{deleteEvents}{redcapApiConnection}(
  rcon,
  events = NULL,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{arms}{\code{character} or \code{integerish} identifying the arm
numbers for which event data will be exported.}

\item{events}{\code{character} giving the unique event names of the events to
be deleted.}

\item{data}{\code{data.frame}. Must have columns \code{event_name} and \code{arm_num}.
To modify existing events, it must also have a column \code{unique_event_name}.
It may optionally have columns for \code{days_offset}, \code{offset_min}, \code{offset_max}.
For backward compatibility, this argument may be passed as \code{event_data}.}

\item{override}{\code{logical(1)}. By default, data will add to or modify
existing arms data. When \code{TRUE}, all the existing arms data is
deleted and replaced with the contents of \code{data}.}

\item{refresh}{\code{logical(1)}. When \code{TRUE}, the cached arms data will
be refreshed after the API action is complete.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportEvents} returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   event_name \tab The user provided name for the event. \cr
   arm_num \tab The arm number the event is associated with. \cr
   unique_event_name \tab The REDCap generated event name. \cr
   custom_event_label \tab An optional user provided label that may be used in place of the event name. \cr
   event_id \tab REDCap's internal event identifier. \cr
   days_offset \tab The number of days since time zero (start of the study or project period) an event is scheduled to occur. This field is only provided when the scheduling module is enabled. \cr
   offset_min \tab The number of days before the \code{days_offset} during which the event may occur. This field is only provided when the scheduling module is enabled. \cr
   offset_max \tab The number of days before the \code{days_offset} during which the event may occur. This field is only provided when  the scheduling module is enabled. \cr
}


\code{importEvents} invisibly returns the number of events added or modified.

\code{deleteEvents} invisibly returns the number of events deleted.
}
\description{
These methods enable the user to export event settings,
import new events, update settings for existing events, or
delete events.
}
\details{
Exporting events is not supported for classical REDCap projects. If
the user attempts to export arms for a classical project, a
data frame will be returned with zero rows.

Additionally, in order for events to be exported, the project must be
longitudinal, have at least one arm, and at least one event defined.
When these conditions are not satifisfied, \code{exportEvents}
will return a data frame with zero rows.

To import new events, the user must provide data with the
\code{unique_event_name} set to \code{NA} (REDCap assigns the unique
event name automatically from the user provided \code{event_name}).

To modify existing events, the user must provide the \code{unique_event_name}.
The other fields in the data provided will overwrite the current values
for the matching event.

Deleting events--whether by \code{deleteEvents} or \code{importEvents} with
\code{override = TRUE}--is a destructive act that also deletes
arms and records associated with the event. This is irreversible
data loss. REDCap will only permit these actions to occur in projects
in Development status.
}
\section{Functions}{
\itemize{
\item \code{exportEvents()}: Export events from a REDCap project.

\item \code{importEvents()}: Add events to a project or modify existing events.

\item \code{deleteEvents()}: Delete events from a project.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Export all events
exportEvents(rcon)

# Export events for a subset of arms
exportEvents(rcon, 
             arms = c(1, 3))
             
# Import new events
NewEvents <- data.frame(event_name = c("Event 1", 
                                       "Event 2"), 
                        arm_num = c(1, 1))
importEvents(rcon, 
             data = NewEvents)
             
# Modify existing events
UpdateEvents <- data.frame(event_name = "Event 2 New Name", 
                           arm_num = 1, 
                           unique_event_name = "event_2_arm_1", 
                           custom_event_label = "The second visit")
importEvents(rcon, 
             data = UpdateEvents)
             
# Replace all events with a new set
NewEvents <- data.frame(event_name = c("Event 1", 
                                       "Event 2", 
                                       "Event 1"), 
                        arm_num = c(1, 1, 2))
importEvents(rcon, 
             data = NewEvents, 
             override = TRUE)
             
# Delete events
deleteEvents(rcon, 
             events = c("event_1_arm_1", "event_1_arm_2"))
}

}
\seealso{
\code{\link[=exportMappings]{exportMappings()}}, \cr
\code{\link[=importMappings]{importMappings()}}
}
