% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportRepeatingInstrumentsEvents.R
\name{exportRepeatingInstrumentsEvents}
\alias{exportRepeatingInstrumentsEvents}
\alias{exportRepeatingInstrumentsEvents.redcapApiConnection}
\title{Export Repeating Instruments and Events Settings}
\usage{
exportRepeatingInstrumentsEvents(rcon, ...)

\method{exportRepeatingInstrumentsEvents}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{...}{Arguments to pass to other methodsArguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This method allows you to export a list of the repeated 
  instruments and repeating events for a project. This includes 
  their unique instrument name as seen in the second column of the 
  Data Dictionary, as well as each repeating instrument's corresponding 
  custom repeating instrument label. For longitudinal projects, the 
  unique event name is also returned for each repeating instrument. 
  Additionally, repeating events are returned as separate items, in 
  which the instrument name will be blank/null to indicate that it is a 
  repeating event (rather than a repeating instrument).
}
