% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteFileRepository.R
\name{deleteFileRepository}
\alias{deleteFileRepository}
\alias{deleteFileRepository.redcapApiConnection}
\title{Delete All Files from the File Repository}
\usage{
deleteFileRepository(rcon, folder_id, recursive = FALSE, ...)

\method{deleteFileRepository}{redcapApiConnection}(
  rcon,
  folder_id,
  recursive = FALSE,
  refresh = TRUE,
  ...,
  confirm = c("ask", "no", "yes"),
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{folder_id}{\code{integerish(1)}. The folder ID from which files
should be deleted. Use \code{folder_id = 0} to delete from the top-level
folder (this is different from other File Repository methods, which 
default to the top-level folder. The difference here is to prevent 
deleting an entire File Repository using a default argument.)}

\item{recursive}{\code{logical(1)}. If \code{TRUE}, files in all subfolders
will be deleted as well.}

\item{...}{Arguments to pass to other methods.
File Repository data on \code{rcon} will be refreshed.}

\item{refresh}{\code{logical(1)}. If \code{TRUE} and the file repository}

\item{confirm}{\code{confirm} \code{character}. One of \code{c("ask", "no", "yes")}. 
When \code{"ask"}, user will be prompted to confirm the deletion. 
When \code{"no"}, the function will terminate with no action. When 
\code{"yes"}, the function will proceed without confirmation (useful
for automated processes).}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Deletes all files in a folder of the file repository. The
  deletion may be applied recursively to sub-folders. Deleted files 
  will remain in the recycling bin for up to 30 days. This function 
  does not provide a way to delete folders.
}
\author{
Benjamin Nutter
}
