% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportVersion.R
\name{exportVersion}
\alias{exportVersion}
\alias{exportVersion.redcapDbConnection}
\alias{exportVersion.redcapApiConnection}
\title{Exports the REDCap Version Number}
\usage{
exportVersion(rcon, ...)

\method{exportVersion}{redcapDbConnection}(rcon, ...)

\method{exportVersion}{redcapApiConnection}(rcon, ..., error_handling = getOption("redcap_error_handling"))
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{...}{Arguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
Version numbers are returned as a character string.
  This feature is available for REDCap 6.0.0 and higher.
}
\details{
If this function is used in a version of REDCap that does not
  support the Export Version Number function, the character string
  \code{'5.12.2'} is returned. This is done solely for the convenience 
  of always returning a value that can be compared against other versions.
}
\section{REDCap API Documentation (6.5.0)}{

This method returns the current REDCap version number as plain text 
(e.g., 4.13.18, 5.12.2, 6.0.0).
}

\section{REDCap Version}{

6.0.0+
}

\section{Known REDCap Limitations}{

None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
