% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncUnderscoreCodings.R
\name{syncUnderscoreCodings}
\alias{syncUnderscoreCodings}
\title{Synchronize coding of checkbox variables between meta data and
records field names.}
\usage{
syncUnderscoreCodings(records, meta_data, export = TRUE)
}
\arguments{
\item{records}{The data frame object returned from the API export
prior to applying factors, labels, and dates via the \code{fieldToVar}
function.}

\item{meta_data}{Metadata export from \code{exportMetaData}}

\item{export}{Logical.  Specifies if data are being synchronized for
import or export}
}
\description{
Due to a bug in the REDCap export module, underscores in
checkbox codings are not retained in the suffixes of the field names
in the exported records.  For example, if variable \code{chk} is a
checkbox with a coding 'a_b, A and B', the field name in the data
export becomes \code{chk___ab}.  The loss of the underscore causes
\code{fieldToVar} to fail as it cannot match variable names to the
meta data.  \code{syncUnderscoreCodings} rectifies this problem by
searching the suffixes and meta data for underscores.  If a
discrepancy is found, the underscores are removed from the metadata
codings, restoring harmony to the universe.  This bug was fixed in
REDCap version 5.5.21 and this function does not apply to that and
later versions.
}
\details{
\code{syncUnderscoreCodings} performs a series of evaluations.  First, it
determines if any underscores are found  in the checkbox codings.
If none are found, the function terminates without changing anything.

If the checkbox codings have underscores, the next evaluation is to
determine if the variable names suffixes have matching underscores.
If they do, then the function terminates with no changes to the meta data.

For data exports, if the prior two checks find underscores in the meta data
and no underscores in the suffixes, the underscores are removed from the
meta data and the new meta data returned.

For data imports, the meta data are not altered and the
\code{checkbox_field_name_map} attribute is used to synchronize field
names to the meta data and the expectations of REDCap (for import,
REDCap expects the underscore codings to be used.
}
\section{Backward Compatibility}{

In retrospect, we realize that the way \code{syncUnderscoreCodings} is written
is backward.  We should have altered the field names in the records
data frame.  Any scripts that make use of \code{syncUnderscoreCodings} and were
written prior to version 5.5.21 will fail because the underscores in the codings
will now be present where they were not before.

For backward compatibility of \code{redcapAPI}, we continue to alter the codings
in the meta data. We do not anticipate many problems, as most people do not use
underscores in the checkbox codings

If your scripts were written under REDCap 5.5.21 or higher, there will be no backward
compatibility problems related to this issue.
}

