\name{redcapProjectInfo}
\alias{redcapProjectInfo}
\alias{redcapProjectInfo.redcapDbConnection}
\alias{redcapProjectInfo.redcapApiConnection}
\title{Export a Project's Supplemental Information}
\description{The meta data, users, arms, events, mappings, and REDCap version can be used to do some validation 
  during data
  exports and imports.  In order to reduce calls to the API, these tables can be stored in an object and 
  referenced as needed.}

\usage{
\method{redcapProjectInfo}{redcapDbConnection}(rcon, date=TRUE, label=TRUE,
                              meta_data=TRUE, users=TRUE, instruments=TRUE,
                              events=TRUE, arms=TRUE, mappings=TRUE,
                              version=TRUE, ...)
\method{redcapProjectInfo}{redcapApiConnection}(rcon, date=TRUE, label=TRUE,
                              meta_data=TRUE, users=TRUE, instruments=TRUE, 
                              events=TRUE, arms=TRUE, mappings=TRUE,
                              version=TRUE, ...,
                              v.number="")
}


\arguments{
  \item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}
  \item{date}{Logical. If \code{TRUE}, user expiration dates are converted to \code{POSIXct} objects.}
  \item{label}{Logical.  If \code{TRUE}, the user form permissions are converted to labelled factors.}
  \item{meta_data}{Logical.  Indicates if the meta data (data dictionary) should be exported.}
  \item{users}{Logical. Indicates if the users table should be exported.}
  \item{instruments}{Logical. Indicates if the instruments table should be exported.}
  \item{events}{Logical. Indicates if the event names should be exported.}
  \item{arms}{Logical. Indicates if the arms table should be exported.}
  \item{mappings}{Logical. Indicates if the form-event mappings should be exported.}
  \item{version}{Indicates if the REDCap version number should be exported.  Only applicable in REDCap 6.0.0 and higher.}
  \item{v.number}{Character string.  Can be used to manually set the REDCap version number for users running a version
      earlier than 6.0.  This is used to validate calls that may only be available in certain versions.}
  \item{...}{Arguments to be passed to other methods}
}

\details{
The project information is stored in the option \code{redcap_project_info}.  If the project is not longitudinal, the 
events, arms, and event-form mappings elements will be assigned character vectors instead of data frames.
}

\author{Benjamin Nutter}

\examples{
\dontrun{
> #*** Note: I cannot provide working examples without
> #*** compromising security.  Instead, I will try to 
> #*** offer up sample code with the matching results
> 
> 
> #*** Create the connection object
> rcon <- redcapConnection(url=[YOUR_REDCAP_URL], token=[API_TOKEN])
> 
> redcapProjectInfo(rcon)
}
}

\keyword{ methods }
