% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangeMapper-ramp.R
\name{ramp}
\alias{ramp}
\title{\strong{ra}nge \strong{m}apper \strong{p}ipe line.}
\usage{
ramp(file, dir = tempdir(), gridSize, spdf, bbox = spdf, ID, biotab,
  metadata, FUN, overwrite = FALSE)
}
\arguments{
\item{file}{project file name.}

\item{dir}{project directory.}

\item{gridSize}{grid resolution (in units previously set by \code{global.bbox.save})}

\item{spdf}{\code{\link[sp]{SpatialPolygonsDataFrame}} object containing all the ranges.}

\item{bbox}{the spatial domain of the project (see \code{\link{global.bbox.save}} )}

\item{ID}{a character vector of length one. An \code{spdf} column name indicating the range ID (e.g. species name).}

\item{biotab}{character string identifying the \sQuote{BIO} table to use.}

\item{metadata}{a named list of functions. See \code{\link{rangeTraits}} and \code{\link{metadata.update}}.}

\item{FUN}{the function to be applied to each pixel. If \code{FUN} is
missing then species richness (species count) is computed.}

\item{overwrite}{logical vector, default to FALSE (the file is kept but all tables are dropped).}
}
\value{
an sqlite connection to a rangeMapper project
}
\description{
A quick alternative to initiate a project by pipelining several functions.
}
\note{
\code{ramp} combines  all the functions from rangeMap.start() to processRanges() and
                rangeMap.save() but is less flexible as compared with a step-by-step
                project building.
}
\examples{
breding_ranges = rgdal::readOGR(system.file(package = "rangeMapper",
     "extdata", "wrens", "vector_combined"), "wrens", verbose = FALSE)
data(wrens)
d = subset(wrens, select = c('sci_name', 'body_size', 'body_mass', 'clutch_size') )
con = ramp("wrens.sqlite", gridSize = 10, spdf = breding_ranges, biotab = d, ID = "sci_name",
            metadata = rangeTraits(), FUN = "median", overwrite = TRUE)
m = rangeMap.fetch(con)
}
\seealso{
\code{\link{rangeMap.start}} \code{\link{global.bbox.save}}
                \code{\link{gridSize.save}} \code{\link{canvas.save}}
                \code{\link{processRanges}} \code{\link{bio.save}}
                \code{\link{rangeMap.save}}
}

