% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\name{makeLines}
\alias{makeLines}
\alias{makeLines,SpatialPoints,SpatialPoints-method}
\title{Make \code{SpatialLines} object from two \code{SpatialPoints} objects}
\usage{
makeLines(from, to)

\S4method{makeLines}{SpatialPoints,SpatialPoints}(from, to)
}
\arguments{
\item{from}{Starting spatial coordinates (\code{SpatialPointsDataFrame}).}

\item{to}{Ending spatial coordinates (\code{SpatialPointsDataFrame}).}
}
\value{
A \code{SpatialLines} object. When this object is used within a
\code{Plot} call and the \code{length} argument is specified, then
arrow heads will be drawn. See examples.
}
\description{
The primary conceived usage of this is to draw arrows following the
trajectories of agents.
}
\examples{
library(sp)
library(raster)

# Make 2 objects
caribou1 <- SpatialPoints(cbind(x = stats::runif(10, -50, 50),
                                y = stats::runif(10, -50, 50)))
caribou2 <- SpatialPoints(cbind(x = stats::runif(10, -50, 50),
                                y = stats::runif(10, -50, 50)))

caribouTraj <- makeLines(caribou1, caribou2)

clearPlot()
Plot(caribouTraj, length = 0.1)

# or  to a previous Plot
files <- dir(system.file("maps", package = "quickPlot"), full.names = TRUE, pattern = "tif")
maps <- lapply(files, raster)
names(maps) <- lapply(maps, names)

caribouTraj <- makeLines(caribou1, caribou2)

clearPlot()
Plot(maps$DEM)
Plot(caribouTraj, addTo = "maps$DEM", length = 0.1)

clearPlot()
}
\author{
Eliot McIntire
}
