% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_query.R
\name{parse_query}
\alias{parse_query}
\title{Parse a SQL query}
\usage{
parse_query(query, tidyverse = FALSE, secure = TRUE)
}
\arguments{
\item{query}{a character string containing a SQL \code{SELECT} statement}

\item{tidyverse}{set to \code{TRUE} to use functions from \pkg{tidyverse}
packages including \pkg{dplyr}, \pkg{stringr}, and \pkg{lubridate} in the R
expressions}

\item{secure}{set to \code{FALSE} to allow potentially dangerous functions in
the returned R expressions}
}
\value{
A list object with named elements representing the clauses of the
  query, containing sublists of unevaluated R expressions translated from the
  SQL expressions in the query.

  Depending on the arguments, the returned list and its sublists will have
  attributes named \code{distinct}, \code{aggregate}, and \code{decreasing}
  with logical values that can aid in the evaluation of the R expressions.
}
\description{
Parses a SQL \code{SELECT} statement into a list with R
  expressions
}
\details{
The query must not contain line comments (\code{--}) or block
  comments (\code{/* */}).

  When one or more individual expressions within a query are longer than 500
  characters, errors or unexpected results can occur.

  See the
  \href{https://cran.r-project.org/package=queryparser/readme/README.html#current-limitations}{current
  limitations} section of the \code{README} for information about what types
  of queries are supported.
}
\examples{
query <- "SELECT origin, dest,
    COUNT(flight) AS num_flts,
    round(AVG(distance)) AS dist,
    round(AVG(arr_delay)) AS avg_delay
  FROM flights
  WHERE distance BETWEEN 200 AND 300
    AND air_time IS NOT NULL
  GROUP BY origin, dest
  HAVING num_flts > 3000
  ORDER BY num_flts DESC, avg_delay DESC
  LIMIT 100;"

parse_query(query)

parse_query(query, tidyverse = TRUE)
}
\seealso{
\code{\link{parse_expression}}
}
