% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_model_table.R
\name{lm_model_table}
\alias{lm_model_table}
\title{Linear Regression Model Table
Generate tables with multiple response and predictor variable (only \code{lm} models are supported)}
\usage{
lm_model_table(
  data,
  response_variable,
  predictor_variable,
  control_variable = NULL,
  marginal_alpha = 0.1,
  return_result = FALSE,
  verbose = TRUE,
  show_p = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{response_variable}{response variable. Support \code{dplyr::select()} syntax.}

\item{predictor_variable}{predictor variable. Support \code{dplyr::select()} syntax. It will automatically remove the response variable from predictor variable, so you can use \code{contains()} or \code{start_with()} safely.}

\item{control_variable}{control variables. Support \code{dplyr::select()} syntax.}

\item{marginal_alpha}{the set marginal_alpha level for marginally significant (denoted by \code{.}). Set to 0.05 if do not want marginally significant denotation.}

\item{return_result}{It set to \code{TRUE}, it return the model estimates data frame.}

\item{verbose}{default is \code{TRUE}. Set to \code{FALSE} to suppress outputs}

\item{show_p}{show the p-value in parenthesis}
}
\value{
data.frame
}
\description{
Linear Regression Model Table
Generate tables with multiple response and predictor variable (only \code{lm} models are supported)
}
\examples{

lm_model_table(data = iris, 
            response_variable = c(Sepal.Length,Sepal.Width),
            predictor_variable = Petal.Width)
}
