% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsSummary.R
\name{modelsSummary}
\alias{modelsSummary}
\title{Make Summary for Model Coefficients}
\usage{
modelsSummary(
  fit = NULL,
  labels = NULL,
  vars = NULL,
  moderator = NULL,
  covar = NULL,
  serial = FALSE,
  data = NULL,
  prefix = "b",
  constant = "iy",
  autoPrefix = TRUE
)
}
\arguments{
\item{fit}{A list of objects of class lm}

\item{labels}{optional list}

\item{vars}{optional list}

\item{moderator}{optional list}

\item{covar}{optional list}

\item{serial}{logical}

\item{data}{optional data.frame}

\item{prefix}{A character}

\item{constant}{A string vector}

\item{autoPrefix}{logical automatic numbering of prefix}
}
\value{
A data.frame
}
\description{
Make Summary for Model Coefficients
}
\examples{
fit1=lm(mpg~wt,data=mtcars)
fit2=lm(mpg~wt*hp*am,data=mtcars)
fit=list(fit1,fit2)
labels=list(Y="mpg",X="wt",W="hp",Z="am")
modelsSummary(fit,labels=labels)
labels=list(Y="withdraw",M="affect",X="estress")
covar=list(name=c("ese","sex","age"),site=list(c("M","Y"),c("M","Y"),c("M","Y")))
modelsSummary(labels=labels,covar=covar,data=estress)
labels=list(X="dysfunc",M="negtone",W="negexp",Y="perform")
moderator=list(name="negexp",site=list(c("a","b","c")))
eq=tripleEquation(labels=labels,moderator=moderator,data=teams,mode=1)
fit=eq2fit(eq,data=teams)
modelsSummary(fit,labels=labels)
labels=list(X="cond",M="pmi",Y="reaction")
modelsSummary(labels=labels,data=pmi)
}
