% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels2table.R
\name{labels2table}
\alias{labels2table}
\title{Make table with labels}
\usage{
labels2table(
  labels = labels,
  vars = list(),
  moderator = list(),
  covar = NULL,
  serial = TRUE,
  bmatrix = NULL,
  eq = NULL
)
}
\arguments{
\item{labels}{A list}

\item{vars}{A list}

\item{moderator}{A list}

\item{covar}{A list}

\item{serial}{A logical}

\item{bmatrix}{integer specifying causal relations among mediators}

\item{eq}{Optional string contains equation}
}
\description{
Make table with labels
}
\examples{
labels=list(X="frame",M="justify",Y="donate",W="skeptic")
moderator=list(name="skeptic",site=list(c("a","c")))
covar=list(name=c("C1","C2","C3"),site=list(c("M","Y"),c("M","Y"),c("M","Y")))
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
labels=list(X="X",M=c("M1","M2"),Y="Y")
moderator=list();serial=FALSE;eq=NULL
labels2table(labels)
labels2table(labels,serial=FALSE)
labels2table(labels,covar=covar)
labels2table(labels,moderator=moderator)
labels=list(X="X",M="M",Y="Y")
moderator=list(name=c("W"),site=list(c("b","c")))
labels2table(labels,moderator=moderator)
labels=list(X="baby",M="wine",Y="tile")
moderator=list(name=c("milk"),site=list("a"))
covar=list(name=c("milk","tent","sand"),site=list(c("Y"),c("M","Y"),c("M","Y")))
labels2table(labels,moderator=moderator,covar=covar,serial=FALSE)
}
