% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixPlot.R
\name{matrixPlot}
\alias{matrixPlot}
\title{Draw matrix plot}
\usage{
matrixPlot(
  matrix = c(1, 1, 1, 0, 0, 1),
  radx = 0.1,
  rady = 0.05,
  xlim = NULL,
  ylim = NULL,
  labels = NULL
)
}
\arguments{
\item{matrix}{A numeric vector}

\item{radx}{horizontal radius of the box.}

\item{rady}{vertical radius of the box.}

\item{xlim}{the x limits (min,max) of the plot}

\item{ylim}{the y limits (min,max) of the plot}

\item{labels}{Optional list of labels}
}
\description{
Draw matrix plot
}
\examples{
matrixPlot(c(1,1,1))
labels=list(X="X",M=c("M1","M2"),Y="Y")
bmatrix=c(1,1,1,0,0,1)
eq=multipleMediation(labels=labels,bmatrix=bmatrix,mode=1)
drawModel(equation=eq,labels=labels,nodemode=2)
matrixPlot(bmatrix)
bmatrix=c(1,1,0,1,0,0,1,1,1,1)
matrixPlot(c(1,1,0,1,0,0,1,1,1,1))
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
eq=multipleMediation(labels=labels,bmatrix=bmatrix,mode=1)
drawModel(equation=eq,labels=labels,parallel=TRUE,nodemode=2)
labels=list(X="indep",M=c("med1","med2"),Y="dep")
matrixPlot(c(1,1,1,0,0,1),labels=labels)
}
