% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tripleInteraction.R
\name{tripleEquation}
\alias{tripleEquation}
\title{Make equation with triple interaction}
\usage{
tripleEquation(X = NULL, M = NULL, Y = NULL, vars = NULL,
  suffix = 0, moderator = list(), covar = NULL, range = TRUE,
  mode = 0, data = NULL, rangemode = 1, probs = c(0.16, 0.5, 0.84))
}
\arguments{
\item{X}{Name of independent variable}

\item{M}{Name of mediator}

\item{Y}{Name of dependent variable}

\item{vars}{A list of variables names and sites}

\item{suffix}{A number}

\item{moderator}{A list of moderators}

\item{covar}{A list of covariates}

\item{range}{A logical}

\item{mode}{A number}

\item{data}{A data.frame}

\item{rangemode}{range mode}

\item{probs}{numeric vector of probabilities with values in [0,1]}
}
\description{
Make equation with triple interaction
}
\examples{
X="negemot";M="ideology";Y="govact";suffix=0
cat(tripleEquation(X=X,M=M,Y=Y))
vars=list(name=list(c("sex","age")),site=list(c("a","c")))
vars=list(name=list(c("W","Z"),c("V","Q")),site=list(c("a","b","c"),c("a","b","c")))
X="negemot";Y="govact";suffix=0
moderator=list(name=c("W"),site=list(c("c")))
cat(tripleEquation(X=X,Y=Y,moderator=moderator))
covar=list(name=c("C1","C2","C3"),label=c("ese","sex","tenure"),site=list(c("M","Y"),"Y","Y"))
cat(tripleEquation(X=X,M=M,Y=Y,moderator=moderator,covar=covar))
cat(tripleEquation(X=X,M=M,Y=Y,moderator=moderator,covar=covar,mode=1))
cat(tripleEquation(X=X,M=M,Y=Y,vars=vars))
cat(tripleEquation(X=X,M=M,Y=Y,vars=vars,moderator=moderator,covar=covar))
cat(tripleEquation(X=X,M=M,Y=Y,vars=vars,mode=1))
cat(tripleEquation(X=X,M=M,Y=Y,vars=vars,covar=covar,mode=1))
X="negemot";Y="govact";suffix=0
vars=list(name=list(c("sex","age")),site=list(c("c")))
cat(tripleEquation(X=X,Y=Y,vars=vars))
}
