% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{write_nested_list}
\alias{write_nested_list}
\title{Write out a nested list}
\usage{
write_nested_list(
  nested_list,
  directory,
  save_as_object = FALSE,
  object_prefix = directory,
  extension = if (save_as_object) ".Rdata" else ".txt",
  ...
)
}
\arguments{
\item{nested_list}{A nested list.}

\item{directory}{Character string. Directory name to which to write the structure.}

\item{save_as_object}{Logical. Save as R object?}

\item{object_prefix}{Character. Prefix of R object. Only used if \code{save_as_object = TRUE}.}

\item{extension}{Character. File extension. Default is ".txt".}

\item{\dots}{Arguments passed to \code{\link{write.table}}}
}
\description{
Write a nested list into a directory structure
}
\examples{
\dontrun{
data("all_linkages_list_P1_subset")
write_nested_list(nested_list = all_linkages_list_P1_subset,
                  directory = "all_linkages_P1",
                  sep="\t")}
}
