% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nm_all.R
\name{read_nm_all}
\alias{read_nm_all}
\title{Read all NONMEM files for a single NONMEM run.}
\usage{
read_nm_all(runNo, run_prefix = "run", directory = NULL, quiet = FALSE, ...)
}
\arguments{
\item{runNo}{Run number.}

\item{run_prefix}{The start to the name of the run.}

\item{directory}{The directory to look for files within.  If NULL, uses the
current directory.}

\item{quiet}{Flag for displaying intermediate output.}

\item{...}{Passed to each of the read functions (ignored in the functions).}
}
\description{
Read all NONMEM files for a single NONMEM run.
}
\details{
The filename for loading is constructed as \code{paste(run_prefix,
  runNo)}.  To load a nonstandard file, simply set one of those values to
  \code{NULL}.
}
\seealso{
Other NONMEM reading: 
\code{\link{plot_scm}()},
\code{\link{read_nm_multi_table}()},
\code{\link{read_nmcov}()},
\code{\link{read_nmext}()},
\code{\link{read_nmtables}()},
\code{\link{read_nm}()},
\code{\link{read_scm}()}
}
\concept{NONMEM reading}
