% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGeneration.R
\name{generateData}
\alias{generateData}
\title{Generates data from a linear Gaussian state space model}
\usage{
generateData(theta, noObservations, initialState)
}
\arguments{
\item{theta}{The parameters \eqn{\theta=\{\phi,\sigma_v,\sigma_e\}} of the 
LGSS model. The parameter \eqn{\phi} that scales the current state in 
the state dynamics is restricted to [-1,1] to obtain a stable model. 
The standard deviations of the state process noise \eqn{\sigma_v} 
and the observation process noise \eqn{\sigma_e} must be positive.}

\item{noObservations}{The number of time points to simulate.}

\item{initialState}{The initial state.}
}
\value{
The function returns a list with the elements: 
\itemize{
\item{x: The latent state for \eqn{t=0,...,T}.}
\item{y: The observation for \eqn{t=0,...,T}.}
}
}
\description{
Generates data from a specific linear Gaussian state space model of the form 
\eqn{ x_{t} = \phi x_{t-1} + \sigma_v v_t } and \eqn{ y_t = x_t + 
\sigma_e e_t }, where \eqn{v_t} and \eqn{e_t} denote independent standard 
Gaussian random variables, i.e. \eqn{N(0,1)}.
}
\references{
Dahlin, J. & Schön, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2017.
}
\author{
Johan Dahlin <uni (at) johandahlin.com.nospam>
}
\keyword{datagen}
