% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_modify_local.R
\name{image_modify_local}
\alias{image_modify_local}
\title{Modify Only a Subregion of an Image}
\usage{
image_modify_local(
  x,
  FUN,
  geometry = "click",
  local = "local",
  rectangle = TRUE,
  trim = FALSE,
  ...
)
}
\arguments{
\item{x}{an image read into R by 
\code{magick::image_read} or an image  
modified by functions in the magick 
package.}

\item{FUN}{the function used to 
modify \code{x}. NOTE: the result 
of \code{FUN} must be of the same 
class as \code{x} and its width and 
height must not be changed during 
modification.}

\item{geometry}{this parameter is 
different from the one used in package 
magick. Here, in this function, you can 
set \code{geometry = "click"} if you want 
to show which part you want to modify 
by mouse click (see 
function \code{image_crop_click} for how to 
use mouse click). Otherwise, you can use 
a length 4 vector with the exact order: left, 
right, top, bottom.}

\item{local}{if it is 1 or "local", only a subregion 
of your image will be modified. If it is 2
or "other", keep the subregion unchanged while 
modifying other parts. If it is 3 or "subregion", 
the result is only the modified subregion, not the 
whole image.}

\item{rectangle}{if it is TRUE (default), the 
subregion is a rectangle. If it is FALSE, 
the subregion can be an irregular polygon 
designated by your mouse click.}

\item{trim}{whether to trim the subregion. 
This is only used when \code{local}
is 3 or "subregion". It helps remove 
the transparent parts. See \code{image_crop_click}
to know how to use this parameter.}

\item{..., }{extra parameters used by 
\code{FUN}.}
}
\description{
The function allows you to modify a subregion  
of your image (or, the opposite, keep the 
subregion unchanged while modifying other parts).
You can set the four sides of the subregion 
or an irregular polygon by 
mouse click. If it is irregular, you MUST 
click in order.
}
