% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_shading_bar.R
\name{geom_shading_bar}
\alias{geom_shading_bar}
\title{Geom Layer for Drawing Shading Barplot}
\usage{
geom_shading_bar(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, width = 0.9, flip = FALSE,
  modify_raster = TRUE, smooth = 15, equal_scale = FALSE,
  space = "rgb", ...)
}
\arguments{
\item{mapping}{aes mapping.}

\item{data}{data. It should be a tbl object.}

\item{stat}{stat.}

\item{position}{position. The parameter will 
not be used here.}

\item{na.rm}{logical, whether to remove NA values.}

\item{show.legend}{This will not be used 
because the layer does not 
create any legend.}

\item{inherit.aes}{logical, 
whether to inherit aes from ggplot().}

\item{width}{see description.}

\item{flip}{see description.}

\item{modify_raster}{see description 
or \code{gg_shading_bar}.}

\item{smooth}{see description.}

\item{equal_scale}{see description
or \code{gg_shading_bar}.}

\item{space}{see description.}

\item{...}{additional parameters.}
}
\description{
This function is similar to 
\code{geom_bar(aes(x, y), stat="identity")} 
except that it draws bars with shading colors. 
Unlike \code{gg_shading_bar} which 
is a convenient function, this function
is used as a ggplot layer. 
Accepted properties are different from those 
in \code{geom_multi_raster} and 
\code{gg_shading_bar}. 
\itemize{
  \item (1) \code{x}. It is the same as that in 
\code{geom_bar}.
  \item (2) \code{y}. It is the same as that in 
\code{geom_bar}.
  \item (3) \code{raster}. It should be 
a list with 1 or more character vectors of 
colors. If the list only has 1 vector, 
all the bars will use the same shading pattern. 
If you 
have, for example, 5 bars to draw, then you 
have to put 5 vectors of colors into a list.
If you use a data frame, it must be a 
data frame made by package tibble, and 
the column for \code{raster} should be 
a list.
  \item (4) \code{width}. It is the same 
as that in \code{geom_bar}.
  \item (5) \code{flip}. The default is FALSE. 
You only need to use TRUE when you 
use \code{coord_flip}. Use outside the 
\code{aes(...)} function.
  \item (6) \code{modify_raster}. If 
it is TRUE (default), colors 
will be smoothed using the value of \code{smooth}. 
If \code{raster} has enough colors, you can set 
this to FALSE. It is the same as that in 
\code{gg_shading_bar}.
  \item (7) \code{equal_scale}. The 
default is FALSE. When it is 
TRUE, a bar will use a certain part of the shading 
colors according to a global scale. It is the same 
as that in \code{gg_shading_bar}.
  \item (8) \code{smooth}. The 
default is 15. The number of 
shading colors each bar has. The bigger, the better.
It is the same as that in \code{gg_shading_bar}.
  \item (9) \code{space}. The color space that is 
used. It can be "rgb" (default) or "Lab".
}
NOTE: the function does interpolation as default, so  
you does not need to 
use \code{interpolate} parameter.
And, unlike \code{gg_shading_bar}, this function 
does not draw lines around rectangles.
}
\examples{
# Example 1: use vectors.
x=c("b", "a", "c", "d", "e")
y=c(2, 1, 3, 5, 4)
raster=list(c("blue", "red"), c("green", "orange"), 
	c("cyan", "yellow"), c("purple", "orangered"), c("grey", "red"))
ggplot()+
	geom_shading_bar(aes(x=x, y=y, raster=raster), smooth=40)
#
# Example 2: other parameters
x=1: 5
y=c(1, 2, -3, 5, 4)
raster=list(c("blue", "red"))
ggplot()+
	geom_shading_bar(aes(x=x, y=y, raster=raster), 
		smooth=50, width=0.6, equal_scale=TRUE)+
	scale_x_continuous(breaks=1: 5, labels=letters[1: 5])
}
