% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mix_comps.R
\name{plot_mix_comps}
\alias{plot_mix_comps}
\title{Plot a Mixture Component}
\usage{
plot_mix_comps(x, mu, sigma, lam)
}
\arguments{
\item{x}{Input data.}

\item{mu}{Mean of component.}

\item{sigma}{Variance of component.}

\item{lam}{Mixture weight of component.}
}
\description{
Plots a mixture component conditioned on a superimposed function
}
\details{
Allows for specifying a custom function to be superimposed when plotting a mixture component
}
\examples{
set.seed(1)
mixmdl <- mixtools::normalmixEM(faithful$waiting, k = 2)
x <- mixmdl$x
x <- data.frame(x)
ggplot2::ggplot(data.frame(x)) +
  ggplot2::geom_histogram(ggplot2::aes(x, ..density..)) +
  ggplot2::stat_function(geom = "line", fun = plot_mix_comps,
                args = list(mixmdl$mu[1], mixmdl$sigma[1], lam = mixmdl$lambda[1]),
                colour = "red") +
  ggplot2::stat_function(geom = "line", fun = plot_mix_comps,
                args = list(mixmdl$mu[2], mixmdl$sigma[2], lam = mixmdl$lambda[2]),
               colour = "blue")
}
