% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_model.R
\name{read_model}
\alias{read_model}
\alias{read_from_multinom}
\alias{read_from_polr}
\alias{read_from_mlogit}
\alias{read_from_vgam}
\alias{read_from_matrix}
\title{Builds up matrix of coefficients from fitted models}
\usage{
read_model(model, type, alpha = NULL, vcov = NULL)

read_from_multinom(model, ...)

read_from_polr(model, ...)

read_from_mlogit(model, ...)

read_from_vgam(model, ...)

read_from_matrix(model, alpha, vcov, ...)
}
\arguments{
\item{model}{see \code{\link[=field3logit]{field3logit()}}.}

\item{type}{class of the model. Currently, forced to \code{"logit"}
by \code{\link[=field3logit]{field3logit()}} when \code{\link[=read_model]{read_model()}} is called.}

\item{alpha}{see \code{\link[=field3logit]{field3logit()}}.}

\item{vcov}{(\strong{only if} the model is read from a matrix, otherwise it will
be ignored) variance-covariance matrix of parameter estimates. The elements
of the variance-covariance matrix should be ordered according to the matrix
of parameter estimates where the categories of the dependent variable are
the slow index, whereas the covariates are the fast index.}

\item{...}{other arguments passed to or from other methods.}
}
\value{
\code{read_model} returns a named \code{list} with the following components:

\item{B}{matrix of coefficients.}
\item{vcovB}{variance-covariance matrix of coefficients.}
\item{alpha}{see \code{\link[=field3logit]{field3logit()}}.}
\item{model}{argument \code{type}.}
\item{ordinal}{\code{logical} variable indicating wheter the model is
ordinal or not.}
\item{P2XB}{link function.}
\item{XB2P}{inverse of the link function.}
\item{DeltaB2pc}{function that computes the points the curve of
the field should pass through (see \code{\link[=DeltaB2pc]{DeltaB2pc()}}).}
}
\description{
\code{\link[=read_model]{read_model()}} reads arguments \code{model}, \code{ordinal}, \code{type} and \code{alpha} passed
by function \code{\link[=field3logit]{field3logit()}} and properly sets the matrix of coefficients
and the other needed model-specific functions.
}
\seealso{
\code{\link{plot3logit-package}}, \code{\link[=field3logit]{field3logit()}}.
}
\keyword{internal}
