\name{repair_docu}
\alias{check_examples}
\alias{check_examples.Rd}
\alias{check_keywords}
\alias{check_keywords.NULL}
\alias{check_keywords.Rd}
\alias{check_keywords.character}
\alias{check_keywords.logical}
\alias{repair_docu}
\alias{repair_docu.Rd}
\alias{repair_docu.character}
\title{Repair and check Rd files}
\usage{
  repair_docu(x, ...)

  \method{repair_docu}{character} (x, ignore = NULL, ...)

  \method{repair_docu}{Rd} (x, remove.dups = FALSE, ...)

  check_keywords(x, ...)

  \method{check_keywords}{NULL} (x, full = FALSE, ...)

  \method{check_keywords}{character} (x, ...)

  \method{check_keywords}{logical} (x, ...)

  \method{check_keywords}{Rd} (x, file = NULL,
    list.only = FALSE, ...)

  check_examples(x, ...)

  \method{check_examples}{Rd} (x, file = NULL, ...)
}
\arguments{
  \item{x}{For \code{repair_docu}, an object of class
  \sQuote{Rd}, or name(s) of Rd file(s) or of one to
  several package directories. See \code{\link{pkg_files}}
  for the possible expansion of names.

  For \code{check_keywords}, an object of class
  \sQuote{Rd}, vector, or \code{NULL}. \sQuote{Rd} objects
  are checked as described below. If \code{NULL}, the total
  list of known keywords is returned as character vector,
  otherwise only those contained in \code{x}. If a logical
  vector, \code{x} is used like the \sQuote{full} argument.
  If a character vector, used to select the descriptions of
  certain keywords.

  For \code{check_examples}, an object of class
  \sQuote{Rd}.}

  \item{remove.dups}{Logical scalar indicating whether
  (probably) duplicate links in the \sQuote{seealso}
  section shall be removed.}

  \item{file}{Optional character scalar indicating the
  filename from which the \sQuote{Rd} object was read.
  Useful when creating messages describing a problem. See
  \code{\link{logfile}}.}

  \item{full}{Logical scalar indicating whether the full
  content of the \sQuote{KEYWORDS.db} file should be
  returned, not just the list of keywords.}

  \item{list.only}{Logical scalar indicating whether the
  keywords should just be collected, not checked against
  the database.}

  \item{...}{Optional arguments passed to and from other
  methods, or between the methods.}

  \item{ignore}{\code{NULL} or a character vector of file
  names (without their directory-name parts) to remove from
  the result. Matching is done case- insensitively. Ignored
  if empty.}
}
\value{
  The \sQuote{Rd} method of \code{repair_docu} returns an
  object of class \sQuote{Rd}, the character method a list
  of such objects, invisibly.

  \code{check_keywords} returns a character vector. As a
  side effect, problem messages are printed to
  \code{stderr}. See \code{\link{logfile}} for how to send
  these messages to a file.

  \code{check_examples} returns a logical scalar,
  \code{TRUE} if examples are either there and should be
  there or are missing and should be missing, \code{FALSE}
  otherwise. As a side effect, problem messages are printed
  to \code{stderr}. See \code{\link{logfile}} for how to
  send these messages to a file.
}
\description{
  The \code{repair_docu} methods repair some sometimes
  encountered, minor problems in Rd files generated by
  \pkg{roxygen2} (but not those related to S4 methods), and
  run the checks implemented in \code{check_keywords} and
  \code{check_examples}.
}
\details{
  \code{check_keywords} checks keywords in Rd files for
  their presence, for their occurrence within the list
  given in the \sQuote{KEYWORDS.db} file that comes with
  \R{}, and for fitting to the \sQuote{docType} of the
  \sQuote{Rd} object. The \sQuote{Rd} method examines the
  content of Rd files.

  In addition to checking that the keywords used are listed
  in the \sQuote{KEYWORDS.db} file, it is checked that
  \sQuote{internal} is not combined with other keywords,
  and that \sQuote{docType} entries such as \sQuote{class},
  \sQuote{data} or \sQuote{package} are accompanied by the
  appropriate keywords.

  \code{check_examples} does \strong{not} run the examples,
  if any, and check their results. It checks
  presence/absence of examples in Rd files. They should not
  be present if the list of \sQuote{keywords} contains
  \sQuote{internal}. Otherwise they should be present
  unless \sQuote{docType} is \sQuote{class} or
  \sQuote{package}.
}
\examples{
# 'Rd' objects
summary(x <- repair_docu(xyplot.docu))
stopifnot(identical(x, xyplot.docu)) # nothing to repair here
(x <- check_keywords(xyplot.docu))
stopifnot(identical(x, "hplot"))
(x <- check_examples(xyplot.docu))
stopifnot(x)

# Character data, or zero arguments
(x <- check_keywords())
stopifnot(length(x) > 1, is.character(x), is.null(names(x)))
(x <- check_keywords(c("aplot", "loess")))
stopifnot(length(x) == 2, is.character(x), names(x) == c("aplot", "loess"))
}
\seealso{
  Other rd-functions: \code{\link{repair_S4_docu}},
  }
\keyword{package}

