% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockruntime_operations.R
\name{bedrockruntime_converse}
\alias{bedrockruntime_converse}
\title{Sends messages to the specified Amazon Bedrock model}
\usage{
bedrockruntime_converse(
  modelId,
  messages,
  system = NULL,
  inferenceConfig = NULL,
  toolConfig = NULL,
  guardrailConfig = NULL,
  additionalModelRequestFields = NULL,
  additionalModelResponseFieldPaths = NULL
)
}
\arguments{
\item{modelId}{[required] The identifier for the model that you want to call.

The \code{modelId} to provide depends on the type of model or throughput that
you use:
\itemize{
\item If you use a base model, specify the model ID or its ARN. For a list
of model IDs for base models, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns}{Amazon Bedrock base model IDs (on-demand throughput)}
in the Amazon Bedrock User Guide.
\item If you use an inference profile, specify the inference profile ID or
its ARN. For a list of inference profile IDs, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html}{Supported Regions and models for cross-region inference}
in the Amazon Bedrock User Guide.
\item If you use a provisioned model, specify the ARN of the Provisioned
Throughput. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html}{Run inference using a Provisioned Throughput}
in the Amazon Bedrock User Guide.
\item If you use a custom model, first purchase Provisioned Throughput for
it. Then specify the ARN of the resulting provisioned model. For
more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html}{Use a custom model in Amazon Bedrock}
in the Amazon Bedrock User Guide.
}

The Converse API doesn't support \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html}{imported models}.}

\item{messages}{[required] The messages that you want to send to the model.}

\item{system}{A system prompt to pass to the model.}

\item{inferenceConfig}{Inference parameters to pass to the model.
\code{\link[=bedrockruntime_converse]{converse}} supports a base set of inference
parameters. If you need to pass additional parameters that the model
supports, use the \code{additionalModelRequestFields} request field.}

\item{toolConfig}{Configuration information for the tools that the model can use when
generating a response.

This field is only supported by Anthropic Claude 3, Cohere Command R,
Cohere Command R+, and Mistral Large models.}

\item{guardrailConfig}{Configuration information for a guardrail that you want to use in the
request.}

\item{additionalModelRequestFields}{Additional inference parameters that the model supports, beyond the base
set of inference parameters that \code{\link[=bedrockruntime_converse]{converse}}
supports in the \code{inferenceConfig} field. For more information, see
\href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html}{Model parameters}.}

\item{additionalModelResponseFieldPaths}{Additional model parameters field paths to return in the response.
\code{\link[=bedrockruntime_converse]{converse}} returns the requested fields as a
JSON Pointer object in the \code{additionalModelResponseFields} field. The
following is example JSON for \code{additionalModelResponseFieldPaths}.

\verb{[ "/stop_sequence" ]}

For information about the JSON Pointer syntax, see the \href{https://datatracker.ietf.org/doc/html/rfc6901}{Internet Engineering Task Force (IETF)} documentation.

\code{\link[=bedrockruntime_converse]{converse}} rejects an empty JSON Pointer or
incorrectly structured JSON Pointer with a \code{400} error code. if the JSON
Pointer is valid, but the requested field is not in the model response,
it is ignored by \code{\link[=bedrockruntime_converse]{converse}}.}
}
\description{
Sends messages to the specified Amazon Bedrock model. \code{\link[=bedrockruntime_converse]{converse}} provides a consistent interface that works with all models that support messages. This allows you to write code once and use it with different models. If a model has unique inference parameters, you can also pass those unique parameters to the model.

See \url{https://www.paws-r-sdk.com/docs/bedrockruntime_converse/} for full documentation.
}
\keyword{internal}
