% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_start_events_detection_job}
\alias{comprehend_start_events_detection_job}
\title{Starts an asynchronous event detection job for a collection of documents}
\usage{
comprehend_start_events_detection_job(
  InputDataConfig,
  OutputDataConfig,
  DataAccessRoleArn,
  JobName = NULL,
  LanguageCode,
  ClientRequestToken = NULL,
  TargetEventTypes,
  Tags = NULL
)
}
\arguments{
\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{OutputDataConfig}{[required] Specifies where to send the output files.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that grants Amazon
Comprehend read access to your input data.}

\item{JobName}{The identifier of the events detection job.}

\item{LanguageCode}{[required] The language code of the input documents.}

\item{ClientRequestToken}{An unique identifier for the request. If you don't set the client
request token, Amazon Comprehend generates one.}

\item{TargetEventTypes}{[required] The types of events to detect in the input documents.}

\item{Tags}{Tags to associate with the events detection job. A tag is a key-value
pair that adds metadata to a resource used by Amazon Comprehend. For
example, a tag with "Sales" as the key might be added to a resource to
indicate its use by the sales department.}
}
\description{
Starts an asynchronous event detection job for a collection of documents.

See \url{https://www.paws-r-sdk.com/docs/comprehend_start_events_detection_job/} for full documentation.
}
\keyword{internal}
