% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_evaluation_job}
\alias{bedrock_create_evaluation_job}
\title{API operation for creating and managing Amazon Bedrock automatic model
evaluation jobs and model evaluation jobs that use human workers}
\usage{
bedrock_create_evaluation_job(
  jobName,
  jobDescription = NULL,
  clientRequestToken = NULL,
  roleArn,
  customerEncryptionKeyId = NULL,
  jobTags = NULL,
  evaluationConfig,
  inferenceConfig,
  outputDataConfig
)
}
\arguments{
\item{jobName}{[required] The name of the model evaluation job. Model evaluation job names must
unique with your AWS account, and your account's AWS region.}

\item{jobDescription}{A description of the model evaluation job.}

\item{clientRequestToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of an IAM service role that Amazon
Bedrock can assume to perform tasks on your behalf. The service role
must have Amazon Bedrock as the service principal, and provide access to
any Amazon S3 buckets specified in the \code{EvaluationConfig} object. To
pass this role to Amazon Bedrock, the caller of this API must have the
\code{iam:PassRole} permission. To learn more about the required permissions,
see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html}{Required permissions}.}

\item{customerEncryptionKeyId}{Specify your customer managed key ARN that will be used to encrypt your
model evaluation job.}

\item{jobTags}{Tags to attach to the model evaluation job.}

\item{evaluationConfig}{[required] Specifies whether the model evaluation job is automatic or uses human
worker.}

\item{inferenceConfig}{[required] Specify the models you want to use in your model evaluation job.
Automatic model evaluation jobs support a single model, and model
evaluation job that use human workers support two models.}

\item{outputDataConfig}{[required] An object that defines where the results of model evaluation job will be
saved in Amazon S3.}
}
\description{
API operation for creating and managing Amazon Bedrock automatic model evaluation jobs and model evaluation jobs that use human workers. To learn more about the requirements for creating a model evaluation job see, \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html}{Model evaluations}.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_evaluation_job/} for full documentation.
}
\keyword{internal}
