% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_translate_text}
\alias{translate_translate_text}
\title{Translates input text from the source language to the target language}
\usage{
translate_translate_text(
  Text,
  TerminologyNames = NULL,
  SourceLanguageCode,
  TargetLanguageCode,
  Settings = NULL
)
}
\arguments{
\item{Text}{[required] The text to translate. The text string can be a maximum of 10,000 bytes
long. Depending on your character set, this may be fewer than 10,000
characters.}

\item{TerminologyNames}{The name of a terminology list file to add to the translation job. This
file provides source terms and the desired translation for each term. A
terminology list can contain a maximum of 256 terms. You can use one
custom terminology resource in your translation request.

Use the \code{\link[=translate_list_terminologies]{list_terminologies}} operation
to get the available terminology lists.

For more information about custom terminology lists, see \href{https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html}{Custom terminology}.}

\item{SourceLanguageCode}{[required] The language code for the language of the source text. For a list of
language codes, see \href{https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html}{Supported languages}.

To have Amazon Translate determine the source language of your text, you
can specify \code{auto} in the \code{SourceLanguageCode} field. If you specify
\code{auto}, Amazon Translate will call \href{https://docs.aws.amazon.com/comprehend/latest/dg/what-is.html}{Amazon Comprehend}
to determine the source language.

If you specify \code{auto}, you must send the
\code{\link[=translate_translate_text]{translate_text}} request in a region that
supports Amazon Comprehend. Otherwise, the request returns an error
indicating that autodetect is not supported.}

\item{TargetLanguageCode}{[required] The language code requested for the language of the target text. For a
list of language codes, see \href{https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html}{Supported languages}.}

\item{Settings}{Settings to configure your translation output, including the option to
set the formality level of the output text and the option to mask
profane words and phrases.}
}
\description{
Translates input text from the source language to the target language. For a list of available languages and language codes, see \href{https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html}{Supported languages}.

See \url{https://www.paws-r-sdk.com/docs/translate_translate_text/} for full documentation.
}
\keyword{internal}
