% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_import_hub_content}
\alias{sagemaker_import_hub_content}
\title{Import hub content}
\usage{
sagemaker_import_hub_content(
  HubContentName,
  HubContentVersion = NULL,
  HubContentType,
  DocumentSchemaVersion,
  HubName,
  HubContentDisplayName = NULL,
  HubContentDescription = NULL,
  HubContentMarkdown = NULL,
  HubContentDocument,
  HubContentSearchKeywords = NULL,
  Tags = NULL
)
}
\arguments{
\item{HubContentName}{[required] The name of the hub content to import.}

\item{HubContentVersion}{The version of the hub content to import.}

\item{HubContentType}{[required] The type of hub content to import.}

\item{DocumentSchemaVersion}{[required] The version of the hub content schema to import.}

\item{HubName}{[required] The name of the hub to import content into.}

\item{HubContentDisplayName}{The display name of the hub content to import.}

\item{HubContentDescription}{A description of the hub content to import.}

\item{HubContentMarkdown}{A string that provides a description of the hub content. This string can
include links, tables, and standard markdown formating.}

\item{HubContentDocument}{[required] The hub content document that describes information about the hub
content such as type, associated containers, scripts, and more.}

\item{HubContentSearchKeywords}{The searchable keywords of the hub content.}

\item{Tags}{Any tags associated with the hub content.}
}
\description{
Import hub content.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_import_hub_content/} for full documentation.
}
\keyword{internal}
