# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include textract_service.R
NULL

#' Analyzes an input document for relationships between detected items
#'
#' @description
#' Analyzes an input document for relationships between detected items.
#'
#' See [https://paws-r.github.io/docs/textract/analyze_document.html](https://paws-r.github.io/docs/textract/analyze_document.html) for full documentation.
#'
#' @param Document &#91;required&#93; The input document as base64-encoded bytes or an Amazon S3 object. If
#' you use the AWS CLI to call Amazon Textract operations, you can't pass
#' image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF
#' format.
#' 
#' If you're using an AWS SDK to call Amazon Textract, you might not need
#' to base64-encode image bytes that are passed using the `Bytes` field.
#' @param FeatureTypes &#91;required&#93; A list of the types of analysis to perform. Add TABLES to the list to
#' return information about the tables that are detected in the input
#' document. Add FORMS to return detected form data. To perform both types
#' of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words
#' detected in the document are included in the response (including text
#' that isn't related to the value of `FeatureTypes`).
#' @param HumanLoopConfig Sets the configuration for the human in the loop workflow for analyzing
#' documents.
#' @param QueriesConfig Contains Queries and the alias for those Queries, as determined by the
#' input.
#'
#' @keywords internal
#'
#' @rdname textract_analyze_document
textract_analyze_document <- function(Document, FeatureTypes, HumanLoopConfig = NULL, QueriesConfig = NULL) {
  op <- new_operation(
    name = "AnalyzeDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$analyze_document_input(Document = Document, FeatureTypes = FeatureTypes, HumanLoopConfig = HumanLoopConfig, QueriesConfig = QueriesConfig)
  output <- .textract$analyze_document_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_document <- textract_analyze_document

#' AnalyzeExpense synchronously analyzes an input document for financially
#' related relationships between text
#'
#' @description
#' [`analyze_expense`][textract_analyze_expense] synchronously analyzes an input document for financially related relationships between text.
#'
#' See [https://paws-r.github.io/docs/textract/analyze_expense.html](https://paws-r.github.io/docs/textract/analyze_expense.html) for full documentation.
#'
#' @param Document &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname textract_analyze_expense
textract_analyze_expense <- function(Document) {
  op <- new_operation(
    name = "AnalyzeExpense",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$analyze_expense_input(Document = Document)
  output <- .textract$analyze_expense_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_expense <- textract_analyze_expense

#' Analyzes identity documents for relevant information
#'
#' @description
#' Analyzes identity documents for relevant information. This information is extracted and returned as `IdentityDocumentFields`, which records both the normalized field and value of the extracted text.Unlike other Amazon Textract operations, [`analyze_id`][textract_analyze_id] doesn't return any Geometry data.
#'
#' See [https://paws-r.github.io/docs/textract/analyze_id.html](https://paws-r.github.io/docs/textract/analyze_id.html) for full documentation.
#'
#' @param DocumentPages &#91;required&#93; The document being passed to AnalyzeID.
#'
#' @keywords internal
#'
#' @rdname textract_analyze_id
textract_analyze_id <- function(DocumentPages) {
  op <- new_operation(
    name = "AnalyzeID",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$analyze_id_input(DocumentPages = DocumentPages)
  output <- .textract$analyze_id_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_id <- textract_analyze_id

#' Detects text in the input document
#'
#' @description
#' Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be an image in JPEG, PNG, PDF, or TIFF format. [`detect_document_text`][textract_detect_document_text] returns the detected text in an array of Block objects.
#'
#' See [https://paws-r.github.io/docs/textract/detect_document_text.html](https://paws-r.github.io/docs/textract/detect_document_text.html) for full documentation.
#'
#' @param Document &#91;required&#93; The input document as base64-encoded bytes or an Amazon S3 object. If
#' you use the AWS CLI to call Amazon Textract operations, you can't pass
#' image bytes. The document must be an image in JPEG or PNG format.
#' 
#' If you're using an AWS SDK to call Amazon Textract, you might not need
#' to base64-encode image bytes that are passed using the `Bytes` field.
#'
#' @keywords internal
#'
#' @rdname textract_detect_document_text
textract_detect_document_text <- function(Document) {
  op <- new_operation(
    name = "DetectDocumentText",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$detect_document_text_input(Document = Document)
  output <- .textract$detect_document_text_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$detect_document_text <- textract_detect_document_text

#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes text in a document
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
#'
#' See [https://paws-r.github.io/docs/textract/get_document_analysis.html](https://paws-r.github.io/docs/textract/get_document_analysis.html) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the text-detection job. The `JobId` is returned
#' from [`start_document_analysis`][textract_start_document_analysis]. A
#' `JobId` value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value that you can specify is 1,000. If you specify a value greater than
#' 1,000, a maximum of 1,000 results is returned. The default value is
#' 1,000.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @keywords internal
#'
#' @rdname textract_get_document_analysis
textract_get_document_analysis <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDocumentAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$get_document_analysis_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_document_analysis_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_document_analysis <- textract_get_document_analysis

#' Gets the results for an Amazon Textract asynchronous operation that
#' detects text in a document
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
#'
#' See [https://paws-r.github.io/docs/textract/get_document_text_detection.html](https://paws-r.github.io/docs/textract/get_document_text_detection.html) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the text detection job. The `JobId` is returned
#' from
#' [`start_document_text_detection`][textract_start_document_text_detection].
#' A `JobId` value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 1,000. If you specify a value greater than
#' 1,000, a maximum of 1,000 results is returned. The default value is
#' 1,000.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @keywords internal
#'
#' @rdname textract_get_document_text_detection
textract_get_document_text_detection <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDocumentTextDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$get_document_text_detection_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_document_text_detection_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_document_text_detection <- textract_get_document_text_detection

#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes invoices and receipts
#'
#' @description
#' Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
#'
#' See [https://paws-r.github.io/docs/textract/get_expense_analysis.html](https://paws-r.github.io/docs/textract/get_expense_analysis.html) for full documentation.
#'
#' @param JobId &#91;required&#93; A unique identifier for the text detection job. The `JobId` is returned
#' from [`start_expense_analysis`][textract_start_expense_analysis]. A
#' `JobId` value is only valid for 7 days.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 20. If you specify a value greater than 20, a
#' maximum of 20 results is returned. The default value is 20.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @keywords internal
#'
#' @rdname textract_get_expense_analysis
textract_get_expense_analysis <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetExpenseAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$get_expense_analysis_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_expense_analysis_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_expense_analysis <- textract_get_expense_analysis

#' Starts the asynchronous analysis of an input document for relationships
#' between detected items such as key-value pairs, tables, and selection
#' elements
#'
#' @description
#' Starts the asynchronous analysis of an input document for relationships between detected items such as key-value pairs, tables, and selection elements.
#'
#' See [https://paws-r.github.io/docs/textract/start_document_analysis.html](https://paws-r.github.io/docs/textract/start_document_analysis.html) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param FeatureTypes &#91;required&#93; A list of the types of analysis to perform. Add TABLES to the list to
#' return information about the tables that are detected in the input
#' document. Add FORMS to return detected form data. To perform both types
#' of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words
#' detected in the document are included in the response (including text
#' that isn't related to the value of `FeatureTypes`).
#' @param ClientRequestToken The idempotent token that you use to identify the start request. If you
#' use the same token with multiple
#' [`start_document_analysis`][textract_start_document_analysis] requests,
#' the same `JobId` is returned. Use `ClientRequestToken` to prevent the
#' same job from being accidentally started more than once. For more
#' information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
#' @param JobTag An identifier that you specify that's included in the completion
#' notification published to the Amazon SNS topic. For example, you can use
#' `JobTag` to identify the type of document that the completion
#' notification corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#' @param OutputConfig Sets if the output will go to a customer defined bucket. By default,
#' Amazon Textract will save the results internally to be accessed by the
#' GetDocumentAnalysis operation.
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side,using SSE-S3.
#' @param QueriesConfig 
#'
#' @keywords internal
#'
#' @rdname textract_start_document_analysis
textract_start_document_analysis <- function(DocumentLocation, FeatureTypes, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL, QueriesConfig = NULL) {
  op <- new_operation(
    name = "StartDocumentAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$start_document_analysis_input(DocumentLocation = DocumentLocation, FeatureTypes = FeatureTypes, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId, QueriesConfig = QueriesConfig)
  output <- .textract$start_document_analysis_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_document_analysis <- textract_start_document_analysis

#' Starts the asynchronous detection of text in a document
#'
#' @description
#' Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
#'
#' See [https://paws-r.github.io/docs/textract/start_document_text_detection.html](https://paws-r.github.io/docs/textract/start_document_text_detection.html) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param ClientRequestToken The idempotent token that's used to identify the start request. If you
#' use the same token with multiple
#' [`start_document_text_detection`][textract_start_document_text_detection]
#' requests, the same `JobId` is returned. Use `ClientRequestToken` to
#' prevent the same job from being accidentally started more than once. For
#' more information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
#' @param JobTag An identifier that you specify that's included in the completion
#' notification published to the Amazon SNS topic. For example, you can use
#' `JobTag` to identify the type of document that the completion
#' notification corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#' @param OutputConfig Sets if the output will go to a customer defined bucket. By default
#' Amazon Textract will save the results internally to be accessed with the
#' GetDocumentTextDetection operation.
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side,using SSE-S3.
#'
#' @keywords internal
#'
#' @rdname textract_start_document_text_detection
textract_start_document_text_detection <- function(DocumentLocation, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL) {
  op <- new_operation(
    name = "StartDocumentTextDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$start_document_text_detection_input(DocumentLocation = DocumentLocation, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId)
  output <- .textract$start_document_text_detection_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_document_text_detection <- textract_start_document_text_detection

#' Starts the asynchronous analysis of invoices or receipts for data like
#' contact information, items purchased, and vendor names
#'
#' @description
#' Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and vendor names.
#'
#' See [https://paws-r.github.io/docs/textract/start_expense_analysis.html](https://paws-r.github.io/docs/textract/start_expense_analysis.html) for full documentation.
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param ClientRequestToken The idempotent token that's used to identify the start request. If you
#' use the same token with multiple
#' [`start_document_text_detection`][textract_start_document_text_detection]
#' requests, the same `JobId` is returned. Use `ClientRequestToken` to
#' prevent the same job from being accidentally started more than once. For
#' more information, see [Calling Amazon Textract Asynchronous
#' Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html)
#' @param JobTag An identifier you specify that's included in the completion notification
#' published to the Amazon SNS topic. For example, you can use `JobTag` to
#' identify the type of document that the completion notification
#' corresponds to (such as a tax form or a receipt).
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#' @param OutputConfig Sets if the output will go to a customer defined bucket. By default,
#' Amazon Textract will save the results internally to be accessed by the
#' [`get_expense_analysis`][textract_get_expense_analysis] operation.
#' @param KMSKeyId The KMS key used to encrypt the inference results. This can be in either
#' Key ID or Key Alias format. When a KMS key is provided, the KMS key will
#' be used for server-side encryption of the objects in the customer
#' bucket. When this parameter is not enabled, the result will be encrypted
#' server side,using SSE-S3.
#'
#' @keywords internal
#'
#' @rdname textract_start_expense_analysis
textract_start_expense_analysis <- function(DocumentLocation, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL, OutputConfig = NULL, KMSKeyId = NULL) {
  op <- new_operation(
    name = "StartExpenseAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$start_expense_analysis_input(DocumentLocation = DocumentLocation, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel, OutputConfig = OutputConfig, KMSKeyId = KMSKeyId)
  output <- .textract$start_expense_analysis_output()
  config <- get_config()
  svc <- .textract$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_expense_analysis <- textract_start_expense_analysis
