% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_compare_faces}
\alias{rekognition_compare_faces}
\title{Compares a face in the \emph{source} input image with each of the 100 largest
faces detected in the \emph{target} input image}
\usage{
rekognition_compare_faces(SourceImage, TargetImage, SimilarityThreshold,
  QualityFilter)
}
\arguments{
\item{SourceImage}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{TargetImage}{[required] The target image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{SimilarityThreshold}{The minimum level of confidence in the face matches that a match must
meet to be included in the \code{FaceMatches} array.}

\item{QualityFilter}{A filter that specifies a quality bar for how much filtering is done to
identify faces. Filtered faces aren\'t compared. If you specify \code{AUTO},
Amazon Rekognition chooses the quality bar. If you specify \code{LOW},
\code{MEDIUM}, or \code{HIGH}, filtering removes all faces that don't meet the
chosen quality bar. The quality bar is based on a variety of common use
cases. Low-quality detections can occur for a number of reasons. Some
examples are an object that\'s misidentified as a face, a face that\'s
too blurry, or a face with a pose that\'s too extreme to use. If you
specify \code{NONE}, no filtering is performed. The default value is \code{NONE}.

To use quality filtering, the collection you are using must be
associated with version 3 of the face model or higher.}
}
\description{
Compares a face in the \emph{source} input image with each of the 100 largest
faces detected in the \emph{target} input image.
}
\details{
If the source image contains multiple faces, the service detects the
largest face and compares it with each face detected in the target
image.

You pass the input and target images either as base64-encoded image
bytes or as references to images in an Amazon S3 bucket. If you use the
AWS CLI to call Amazon Rekognition operations, passing image bytes
isn\'t supported. The image must be formatted as a PNG or JPEG file.

In response, the operation returns an array of face matches ordered by
similarity score in descending order. For each face match, the response
provides a bounding box of the face, facial landmarks, pose details
(pitch, role, and yaw), quality (brightness and sharpness), and
confidence value (indicating the level of confidence that the bounding
box contains a face). The response also provides a similarity score,
which indicates how closely the faces match.

By default, only faces with a similarity score of greater than or equal
to 80\% are returned in the response. You can change this value by
specifying the \code{SimilarityThreshold} parameter.

\code{CompareFaces} also returns an array of faces that don\'t match the
source image. For each face, it returns a bounding box, confidence
value, landmarks, pose details, and quality. The response also returns
information about the face in the source image, including the bounding
box of the face and confidence value.

The \code{QualityFilter} input parameter allows you to filter out detected
faces that don't meet a required quality bar. The quality bar is based
on a variety of common use cases. Use \code{QualityFilter} to set the quality
bar by specifying \code{LOW}, \code{MEDIUM}, or \code{HIGH}. If you do not want to
filter detected faces, specify \code{NONE}. The default value is \code{NONE}.

To use quality filtering, you need a collection associated with version
3 of the face model or higher. To get the version of the face model
associated with a collection, call DescribeCollection.

If the image doesn\'t contain Exif metadata, \code{CompareFaces} returns
orientation information for the source and target images. Use these
values to display the images with the correct image orientation.

If no faces are detected in the source or target images, \code{CompareFaces}
returns an \code{InvalidParameterException} error.

This is a stateless API operation. That is, data returned by this
operation doesn\'t persist.

For an example, see Comparing Faces in Images in the Amazon Rekognition
Developer Guide.

This operation requires permissions to perform the
\code{rekognition:CompareFaces} action.
}
\section{Request syntax}{
\preformatted{svc$compare_faces(
  SourceImage = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  TargetImage = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  SimilarityThreshold = 123.0,
  QualityFilter = "NONE"|"AUTO"|"LOW"|"MEDIUM"|"HIGH"
)
}
}

\examples{
\dontrun{
# This operation compares the largest face detected in the source image
# with each face detected in the target image.
svc$compare_faces(
  SimilarityThreshold = 90L,
  SourceImage = list(
    S3Object = list(
      Bucket = "mybucket",
      Name = "mysourceimage"
    )
  ),
  TargetImage = list(
    S3Object = list(
      Bucket = "mybucket",
      Name = "mytargetimage"
    )
  )
)
}

}
\keyword{internal}
