# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include transcribeservice_service.R
NULL

#' Creates a new custom vocabulary that you can use to change the way
#' Amazon Transcribe handles transcription of an audio file
#'
#' Creates a new custom vocabulary that you can use to change the way
#' Amazon Transcribe handles transcription of an audio file.
#'
#' @usage
#' transcribeservice_create_vocabulary(VocabularyName, LanguageCode,
#'   Phrases, VocabularyFileUri)
#'
#' @param VocabularyName &#91;required&#93; The name of the vocabulary. The name must be unique within an AWS
#' account. The name is case-sensitive.
#' @param LanguageCode &#91;required&#93; The language code of the vocabulary entries.
#' @param Phrases An array of strings that contains the vocabulary entries.
#' @param VocabularyFileUri The S3 location of the text file that contains the definition of the
#' custom vocabulary. The URI must be in the same region as the API
#' endpoint that you are calling. The general form is
#' 
#' ` https://s3-&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; `
#' 
#' For example:
#' 
#' `https://s3-us-east-1.amazonaws.com/examplebucket/vocab.txt`
#' 
#' For more information about S3 object names, see [Object
#' Keys](http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
#' in the *Amazon S3 Developer Guide*.
#' 
#' For more information about custom vocabularies, see [Custom
#' Vocabularies](http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
#'
#' @section Request syntax:
#' ```
#' svc$create_vocabulary(
#'   VocabularyName = "string",
#'   LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA",
#'   Phrases = list(
#'     "string"
#'   ),
#'   VocabularyFileUri = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_create_vocabulary
transcribeservice_create_vocabulary <- function(VocabularyName, LanguageCode, Phrases = NULL, VocabularyFileUri = NULL) {
  op <- new_operation(
    name = "CreateVocabulary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$create_vocabulary_input(VocabularyName = VocabularyName, LanguageCode = LanguageCode, Phrases = Phrases, VocabularyFileUri = VocabularyFileUri)
  output <- .transcribeservice$create_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$create_vocabulary <- transcribeservice_create_vocabulary

#' Deletes a previously submitted transcription job along with any other
#' generated results such as the transcription, models, and so on
#'
#' Deletes a previously submitted transcription job along with any other
#' generated results such as the transcription, models, and so on.
#'
#' @usage
#' transcribeservice_delete_transcription_job(TranscriptionJobName)
#'
#' @param TranscriptionJobName &#91;required&#93; The name of the transcription job to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transcription_job(
#'   TranscriptionJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_transcription_job
transcribeservice_delete_transcription_job <- function(TranscriptionJobName) {
  op <- new_operation(
    name = "DeleteTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$delete_transcription_job_input(TranscriptionJobName = TranscriptionJobName)
  output <- .transcribeservice$delete_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_transcription_job <- transcribeservice_delete_transcription_job

#' Deletes a vocabulary from Amazon Transcribe
#'
#' Deletes a vocabulary from Amazon Transcribe.
#'
#' @usage
#' transcribeservice_delete_vocabulary(VocabularyName)
#'
#' @param VocabularyName &#91;required&#93; The name of the vocabulary to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vocabulary(
#'   VocabularyName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_delete_vocabulary
transcribeservice_delete_vocabulary <- function(VocabularyName) {
  op <- new_operation(
    name = "DeleteVocabulary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$delete_vocabulary_input(VocabularyName = VocabularyName)
  output <- .transcribeservice$delete_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$delete_vocabulary <- transcribeservice_delete_vocabulary

#' Returns information about a transcription job
#'
#' Returns information about a transcription job. To see the status of the
#' job, check the `TranscriptionJobStatus` field. If the status is
#' `COMPLETED`, the job is finished and you can find the results at the
#' location specified in the `TranscriptionFileUri` field.
#'
#' @usage
#' transcribeservice_get_transcription_job(TranscriptionJobName)
#'
#' @param TranscriptionJobName &#91;required&#93; The name of the job.
#'
#' @section Request syntax:
#' ```
#' svc$get_transcription_job(
#'   TranscriptionJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_transcription_job
transcribeservice_get_transcription_job <- function(TranscriptionJobName) {
  op <- new_operation(
    name = "GetTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$get_transcription_job_input(TranscriptionJobName = TranscriptionJobName)
  output <- .transcribeservice$get_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_transcription_job <- transcribeservice_get_transcription_job

#' Gets information about a vocabulary
#'
#' Gets information about a vocabulary.
#'
#' @usage
#' transcribeservice_get_vocabulary(VocabularyName)
#'
#' @param VocabularyName &#91;required&#93; The name of the vocabulary to return information about. The name is
#' case-sensitive.
#'
#' @section Request syntax:
#' ```
#' svc$get_vocabulary(
#'   VocabularyName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_get_vocabulary
transcribeservice_get_vocabulary <- function(VocabularyName) {
  op <- new_operation(
    name = "GetVocabulary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$get_vocabulary_input(VocabularyName = VocabularyName)
  output <- .transcribeservice$get_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$get_vocabulary <- transcribeservice_get_vocabulary

#' Lists transcription jobs with the specified status
#'
#' Lists transcription jobs with the specified status.
#'
#' @usage
#' transcribeservice_list_transcription_jobs(Status, JobNameContains,
#'   NextToken, MaxResults)
#'
#' @param Status When specified, returns only transcription jobs with the specified
#' status. Jobs are ordered by creation date, with the newest jobs returned
#' first. If you don't specify a status, Amazon Transcribe returns all
#' transcription jobs ordered by creation date.
#' @param JobNameContains When specified, the jobs returned in the list are limited to jobs whose
#' name contains the specified string.
#' @param NextToken If the result of the previous request to `ListTranscriptionJobs` was
#' truncated, include the `NextToken` to fetch the next set of jobs.
#' @param MaxResults The maximum number of jobs to return in the response. If there are fewer
#' results in the list, this response contains only the actual results.
#'
#' @section Request syntax:
#' ```
#' svc$list_transcription_jobs(
#'   Status = "IN_PROGRESS"|"FAILED"|"COMPLETED",
#'   JobNameContains = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_transcription_jobs
transcribeservice_list_transcription_jobs <- function(Status = NULL, JobNameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTranscriptionJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$list_transcription_jobs_input(Status = Status, JobNameContains = JobNameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .transcribeservice$list_transcription_jobs_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_transcription_jobs <- transcribeservice_list_transcription_jobs

#' Returns a list of vocabularies that match the specified criteria
#'
#' Returns a list of vocabularies that match the specified criteria. If no
#' criteria are specified, returns the entire list of vocabularies.
#'
#' @usage
#' transcribeservice_list_vocabularies(NextToken, MaxResults, StateEquals,
#'   NameContains)
#'
#' @param NextToken If the result of the previous request to `ListVocabularies` was
#' truncated, include the `NextToken` to fetch the next set of jobs.
#' @param MaxResults The maximum number of vocabularies to return in the response. If there
#' are fewer results in the list, this response contains only the actual
#' results.
#' @param StateEquals When specified, only returns vocabularies with the `VocabularyState`
#' field equal to the specified state.
#' @param NameContains When specified, the vocabularies returned in the list are limited to
#' vocabularies whose name contains the specified string. The search is
#' case-insensitive, `ListVocabularies` will return both \"vocabularyname\"
#' and \"VocabularyName\" in the response list.
#'
#' @section Request syntax:
#' ```
#' svc$list_vocabularies(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   StateEquals = "PENDING"|"READY"|"FAILED",
#'   NameContains = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_list_vocabularies
transcribeservice_list_vocabularies <- function(NextToken = NULL, MaxResults = NULL, StateEquals = NULL, NameContains = NULL) {
  op <- new_operation(
    name = "ListVocabularies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$list_vocabularies_input(NextToken = NextToken, MaxResults = MaxResults, StateEquals = StateEquals, NameContains = NameContains)
  output <- .transcribeservice$list_vocabularies_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$list_vocabularies <- transcribeservice_list_vocabularies

#' Starts an asynchronous job to transcribe speech to text
#'
#' Starts an asynchronous job to transcribe speech to text.
#'
#' @usage
#' transcribeservice_start_transcription_job(TranscriptionJobName,
#'   LanguageCode, MediaSampleRateHertz, MediaFormat, Media,
#'   OutputBucketName, Settings)
#'
#' @param TranscriptionJobName &#91;required&#93; The name of the job. Note that you can\'t use the strings \".\" or
#' \"..\" by themselves as the job name. The name must also be unique
#' within an AWS account.
#' @param LanguageCode &#91;required&#93; The language code for the language used in the input media file.
#' @param MediaSampleRateHertz The sample rate, in Hertz, of the audio track in the input media file.
#' @param MediaFormat &#91;required&#93; The format of the input media file.
#' @param Media &#91;required&#93; An object that describes the input media for a transcription job.
#' @param OutputBucketName The location where the transcription is stored.
#' 
#' If you set the `OutputBucketName`, Amazon Transcribe puts the
#' transcription in the specified S3 bucket. When you call the
#' GetTranscriptionJob operation, the operation returns this location in
#' the `TranscriptFileUri` field. The S3 bucket must have permissions that
#' allow Amazon Transcribe to put files in the bucket. For more
#' information, see [Permissions Required for IAM User
#' Roles](https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user).
#' 
#' Amazon Transcribe uses the default Amazon S3 key for server-side
#' encryption of transcripts that are placed in your S3 bucket. You can\'t
#' specify your own encryption key.
#' 
#' If you don\'t set the `OutputBucketName`, Amazon Transcribe generates a
#' pre-signed URL, a shareable URL that provides secure access to your
#' transcription, and returns it in the `TranscriptFileUri` field. Use this
#' URL to download the transcription.
#' @param Settings A `Settings` object that provides optional settings for a transcription
#' job.
#'
#' @section Request syntax:
#' ```
#' svc$start_transcription_job(
#'   TranscriptionJobName = "string",
#'   LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA",
#'   MediaSampleRateHertz = 123,
#'   MediaFormat = "mp3"|"mp4"|"wav"|"flac",
#'   Media = list(
#'     MediaFileUri = "string"
#'   ),
#'   OutputBucketName = "string",
#'   Settings = list(
#'     VocabularyName = "string",
#'     ShowSpeakerLabels = TRUE|FALSE,
#'     MaxSpeakerLabels = 123,
#'     ChannelIdentification = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_start_transcription_job
transcribeservice_start_transcription_job <- function(TranscriptionJobName, LanguageCode, MediaSampleRateHertz = NULL, MediaFormat, Media, OutputBucketName = NULL, Settings = NULL) {
  op <- new_operation(
    name = "StartTranscriptionJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$start_transcription_job_input(TranscriptionJobName = TranscriptionJobName, LanguageCode = LanguageCode, MediaSampleRateHertz = MediaSampleRateHertz, MediaFormat = MediaFormat, Media = Media, OutputBucketName = OutputBucketName, Settings = Settings)
  output <- .transcribeservice$start_transcription_job_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$start_transcription_job <- transcribeservice_start_transcription_job

#' Updates an existing vocabulary with new values
#'
#' Updates an existing vocabulary with new values. The `UpdateVocabulary`
#' operation overwrites all of the existing information with the values
#' that you provide in the request.
#'
#' @usage
#' transcribeservice_update_vocabulary(VocabularyName, LanguageCode,
#'   Phrases, VocabularyFileUri)
#'
#' @param VocabularyName &#91;required&#93; The name of the vocabulary to update. The name is case-sensitive.
#' @param LanguageCode &#91;required&#93; The language code of the vocabulary entries.
#' @param Phrases An array of strings containing the vocabulary entries.
#' @param VocabularyFileUri The S3 location of the text file that contains the definition of the
#' custom vocabulary. The URI must be in the same region as the API
#' endpoint that you are calling. The general form is
#' 
#' ` https://s3-&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; `
#' 
#' For example:
#' 
#' `https://s3-us-east-1.amazonaws.com/examplebucket/vocab.txt`
#' 
#' For more information about S3 object names, see [Object
#' Keys](http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
#' in the *Amazon S3 Developer Guide*.
#' 
#' For more information about custom vocabularies, see [Custom
#' Vocabularies](http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
#'
#' @section Request syntax:
#' ```
#' svc$update_vocabulary(
#'   VocabularyName = "string",
#'   LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA",
#'   Phrases = list(
#'     "string"
#'   ),
#'   VocabularyFileUri = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname transcribeservice_update_vocabulary
transcribeservice_update_vocabulary <- function(VocabularyName, LanguageCode, Phrases = NULL, VocabularyFileUri = NULL) {
  op <- new_operation(
    name = "UpdateVocabulary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .transcribeservice$update_vocabulary_input(VocabularyName = VocabularyName, LanguageCode = LanguageCode, Phrases = Phrases, VocabularyFileUri = VocabularyFileUri)
  output <- .transcribeservice$update_vocabulary_output()
  config <- get_config()
  svc <- .transcribeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.transcribeservice$operations$update_vocabulary <- transcribeservice_update_vocabulary
