% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_get_face_search}
\alias{rekognition_get_face_search}
\title{Gets the face search results for Amazon Rekognition Video face search
started by StartFaceSearch}
\usage{
rekognition_get_face_search(JobId, MaxResults, NextToken, SortBy)
}
\arguments{
\item{JobId}{[required] The job identifer for the search request. You get the job identifier
from an initial call to \code{StartFaceSearch}.}

\item{MaxResults}{Maximum number of results to return per paginated call. The largest
value you can specify is 1000. If you specify a value greater than 1000,
a maximum of 1000 results is returned. The default value is 1000.}

\item{NextToken}{If the previous response was incomplete (because there is more search
results to retrieve), Amazon Rekognition Video returns a pagination
token in the response. You can use this pagination token to retrieve the
next set of search results.}

\item{SortBy}{Sort to use for grouping faces in the response. Use \code{TIMESTAMP} to group
faces by the time that they are recognized. Use \code{INDEX} to sort by
recognized faces.}
}
\description{
Gets the face search results for Amazon Rekognition Video face search
started by StartFaceSearch. The search returns faces in a collection
that match the faces of persons detected in a video. It also includes
the time(s) that faces are matched in the video.
}
\details{
Face search in a video is an asynchronous operation. You start face
search by calling to StartFaceSearch which returns a job identifier
(\code{JobId}). When the search operation finishes, Amazon Rekognition Video
publishes a completion status to the Amazon Simple Notification Service
topic registered in the initial call to \code{StartFaceSearch}. To get the
search results, first check that the status value published to the
Amazon SNS topic is \code{SUCCEEDED}. If so, call \code{GetFaceSearch} and pass
the job identifier (\code{JobId}) from the initial call to \code{StartFaceSearch}.

For more information, see Searching Faces in a Collection in the Amazon
Rekognition Developer Guide.

The search results are retured in an array, \code{Persons}, of PersonMatch
objects. Each\code{PersonMatch} element contains details about the matching
faces in the input collection, person information (facial attributes,
bounding boxes, and person identifer) for the matched person, and the
time the person was matched in the video.

\code{GetFaceSearch} only returns the default facial attributes
(\code{BoundingBox}, \code{Confidence}, \code{Landmarks}, \code{Pose}, and \code{Quality}). The
other facial attributes listed in the \code{Face} object of the following
response syntax are not returned. For more information, see FaceDetail
in the Amazon Rekognition Developer Guide.

By default, the \code{Persons} array is sorted by the time, in milliseconds
from the start of the video, persons are matched. You can also sort by
persons by specifying \code{INDEX} for the \code{SORTBY} input parameter.
}
\section{Request syntax}{
\preformatted{svc$get_face_search(
  JobId = "string",
  MaxResults = 123,
  NextToken = "string",
  SortBy = "INDEX"|"TIMESTAMP"
)
}
}

\keyword{internal}
