% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_medical_transcription_jobs}
\alias{transcribeservice_list_medical_transcription_jobs}
\title{Lists medical transcription jobs with a specified status or substring
that matches their names}
\usage{
transcribeservice_list_medical_transcription_jobs(Status,
  JobNameContains, NextToken, MaxResults)
}
\arguments{
\item{Status}{When specified, returns only medical transcription jobs with the
specified status. Jobs are ordered by creation date, with the newest
jobs returned first. If you don't specify a status, Amazon Transcribe
Medical returns all transcription jobs ordered by creation date.}

\item{JobNameContains}{When specified, the jobs returned in the list are limited to jobs whose
name contains the specified string.}

\item{NextToken}{If you a receive a truncated result in the previous request of
\code{\link[=transcribeservice_list_medical_transcription_jobs]{list_medical_transcription_jobs}},
include \code{NextToken} to fetch the next set of jobs.}

\item{MaxResults}{The maximum number of medical transcription jobs to return in the
response. IF there are fewer results in the list, this response contains
only the actual results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
  NextToken = "string",
  MedicalTranscriptionJobSummaries = list(
    list(
      MedicalTranscriptionJobName = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      CompletionTime = as.POSIXct(
        "2015-01-01"
      ),
      LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
      TranscriptionJobStatus = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
      FailureReason = "string",
      OutputLocationType = "CUSTOMER_BUCKET"|"SERVICE_BUCKET",
      Specialty = "PRIMARYCARE",
      Type = "CONVERSATION"|"DICTATION"
    )
  )
)
}
}
\description{
Lists medical transcription jobs with a specified status or substring
that matches their names.
}
\section{Request syntax}{
\preformatted{svc$list_medical_transcription_jobs(
  Status = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
  JobNameContains = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
