% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_create_vocabulary}
\alias{transcribeservice_create_vocabulary}
\title{Creates a new custom vocabulary that you can use to change the way
Amazon Transcribe handles transcription of an audio file}
\usage{
transcribeservice_create_vocabulary(VocabularyName, LanguageCode,
  Phrases, VocabularyFileUri)
}
\arguments{
\item{VocabularyName}{[required] The name of the vocabulary. The name must be unique within an AWS
account. The name is case sensitive. If you try to create a vocabulary
with the same name as a previous vocabulary you will receive a
\code{ConflictException} error.}

\item{LanguageCode}{[required] The language code of the vocabulary entries.}

\item{Phrases}{An array of strings that contains the vocabulary entries.}

\item{VocabularyFileUri}{The S3 location of the text file that contains the definition of the
custom vocabulary. The URI must be in the same region as the API
endpoint that you are calling. The general form is

For more information about S3 object names, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys}{Object Keys}
in the \emph{Amazon S3 Developer Guide}.

For more information about custom vocabularies, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary}{Custom Vocabularies}.}
}
\description{
Creates a new custom vocabulary that you can use to change the way
Amazon Transcribe handles transcription of an audio file.
}
\section{Request syntax}{
\preformatted{svc$create_vocabulary(
  VocabularyName = "string",
  LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
  Phrases = list(
    "string"
  ),
  VocabularyFileUri = "string"
)
}
}

\keyword{internal}
