% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_delete_entity_recognizer}
\alias{comprehend_delete_entity_recognizer}
\title{Deletes an entity recognizer}
\usage{
comprehend_delete_entity_recognizer(EntityRecognizerArn)
}
\arguments{
\item{EntityRecognizerArn}{[required] The Amazon Resource Name (ARN) that identifies the entity recognizer.}
}
\description{
Deletes an entity recognizer.

Only those recognizers that are in terminated states (IN\\_ERROR,
TRAINED) will be deleted. If an active inference job is using the model,
a \code{ResourceInUseException} will be returned.

This is an asynchronous action that puts the recognizer into a DELETING
state, and it is then removed by a background job. Once removed, the
recognizer disappears from your account and is no longer available for
use.
}
\section{Request syntax}{
\preformatted{svc$delete_entity_recognizer(
  EntityRecognizerArn = "string"
)
}
}

\keyword{internal}
