% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_endpoint_config}
\alias{sagemaker_create_endpoint_config}
\title{Creates an endpoint configuration that Amazon SageMaker hosting services
uses to deploy models}
\usage{
sagemaker_create_endpoint_config(EndpointConfigName, ProductionVariants,
  Tags, KmsKeyId)
}
\arguments{
\item{EndpointConfigName}{[required] The name of the endpoint configuration. You specify this name in a
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html}{CreateEndpoint}
request.}

\item{ProductionVariants}{[required] An array of \code{ProductionVariant} objects, one for each model that you
want to host at this endpoint.}

\item{Tags}{An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.}

\item{KmsKeyId}{The Amazon Resource Name (ARN) of a AWS Key Management Service key that
Amazon SageMaker uses to encrypt data on the storage volume attached to
the ML compute instance that hosts the endpoint.}
}
\description{
Creates an endpoint configuration that Amazon SageMaker hosting services
uses to deploy models. In the configuration, you identify one or more
models, created using the \code{CreateModel} API, to deploy and the resources
that you want Amazon SageMaker to provision. Then you call the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html}{CreateEndpoint}
API.
}
\details{
Use this API only if you want to use Amazon SageMaker hosting services
to deploy models into production.

In the request, you define one or more \code{ProductionVariant}s, each of
which identifies a model. Each \code{ProductionVariant} parameter also
describes the resources that you want Amazon SageMaker to provision.
This includes the number and type of ML compute instances to deploy.

If you are hosting multiple models, you also assign a \code{VariantWeight} to
specify how much traffic you want to allocate to each model. For
example, suppose that you want to host two models, A and B, and you
assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker
distributes two-thirds of the traffic to Model A, and one-third to model
B.
}
\section{Request syntax}{
\preformatted{svc$create_endpoint_config(
  EndpointConfigName = "string",
  ProductionVariants = list(
    list(
      VariantName = "string",
      ModelName = "string",
      InitialInstanceCount = 123,
      InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge",
      InitialVariantWeight = 123.0,
      AcceleratorType = "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string"
)
}
}

\keyword{internal}
