% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_get_resources}
\alias{workdocs_get_resources}
\title{Retrieves a collection of resources, including folders and documents}
\usage{
workdocs_get_resources(
  AuthenticationToken = NULL,
  UserId = NULL,
  CollectionType = NULL,
  Limit = NULL,
  Marker = NULL
)
}
\arguments{
\item{AuthenticationToken}{The Amazon WorkDocs authentication token. Not required when using Amazon
Web Services administrator credentials to access the API.}

\item{UserId}{The user ID for the resource collection. This is a required field for
accessing the API operation using IAM credentials.}

\item{CollectionType}{The collection type.}

\item{Limit}{The maximum number of resources to return.}

\item{Marker}{The marker for the next set of results. This marker was received from a
previous call.}
}
\description{
Retrieves a collection of resources, including folders and documents. The only \code{CollectionType} supported is \code{SHARED_WITH_ME}.

See \url{https://www.paws-r-sdk.com/docs/workdocs_get_resources/} for full documentation.
}
\keyword{internal}
