% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_copy_image}
\alias{appstream_copy_image}
\title{Copies the image within the same region or to a new region within the
same AWS account}
\usage{
appstream_copy_image(
  SourceImageName,
  DestinationImageName,
  DestinationRegion,
  DestinationImageDescription = NULL
)
}
\arguments{
\item{SourceImageName}{[required] The name of the image to copy.}

\item{DestinationImageName}{[required] The name that the image will have when it is copied to the destination.}

\item{DestinationRegion}{[required] The destination region to which the image will be copied. This parameter
is required, even if you are copying an image within the same region.}

\item{DestinationImageDescription}{The description that the image will have when it is copied to the
destination.}
}
\description{
Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.

See \url{https://paws-r.github.io/docs/appstream/copy_image.html} for full documentation.
}
\keyword{internal}
