% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_get_document_path}
\alias{workdocs_get_document_path}
\title{Retrieves the path information (the hierarchy from the root folder) for
the requested document}
\usage{
workdocs_get_document_path(AuthenticationToken, DocumentId, Limit,
  Fields, Marker)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{Limit}{The maximum number of levels in the hierarchy to return.}

\item{Fields}{A comma-separated list of values. Specify \code{NAME} to include the names of
the parent folders.}

\item{Marker}{This value is not supported.}
}
\value{
A list with the following syntax:\preformatted{list(
  Path = list(
    Components = list(
      list(
        Id = "string",
        Name = "string"
      )
    )
  )
)
}
}
\description{
Retrieves the path information (the hierarchy from the root folder) for
the requested document.

By default, Amazon WorkDocs returns a maximum of 100 levels upwards from
the requested document and only includes the IDs of the parent folders
in the path. You can limit the maximum number of levels. You can also
request the names of the parent folders.
}
\section{Request syntax}{
\preformatted{svc$get_document_path(
  AuthenticationToken = "string",
  DocumentId = "string",
  Limit = 123,
  Fields = "string",
  Marker = "string"
)
}
}

\keyword{internal}
