% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_images}
\alias{appstream_describe_images}
\title{Retrieves a list that describes one or more specified images, if the
image names or image ARNs are provided}
\usage{
appstream_describe_images(Names, Arns, Type, NextToken, MaxResults)
}
\arguments{
\item{Names}{The names of the public or private images to describe.}

\item{Arns}{The ARNs of the public, private, and shared images to describe.}

\item{Type}{The type of image (public, private, or shared) to describe.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}

\item{MaxResults}{The maximum size of each page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Images = list(
    list(
      Name = "string",
      Arn = "string",
      BaseImageArn = "string",
      DisplayName = "string",
      State = "PENDING"|"AVAILABLE"|"FAILED"|"COPYING"|"DELETING",
      Visibility = "PUBLIC"|"PRIVATE"|"SHARED",
      ImageBuilderSupported = TRUE|FALSE,
      ImageBuilderName = "string",
      Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
      Description = "string",
      StateChangeReason = list(
        Code = "INTERNAL_ERROR"|"IMAGE_BUILDER_NOT_AVAILABLE"|"IMAGE_COPY_FAILURE",
        Message = "string"
      ),
      Applications = list(
        list(
          Name = "string",
          DisplayName = "string",
          IconURL = "string",
          LaunchPath = "string",
          LaunchParameters = "string",
          Enabled = TRUE|FALSE,
          Metadata = list(
            "string"
          )
        )
      ),
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      PublicBaseImageReleasedDate = as.POSIXct(
        "2015-01-01"
      ),
      AppstreamAgentVersion = "string",
      ImagePermissions = list(
        allowFleet = TRUE|FALSE,
        allowImageBuilder = TRUE|FALSE
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes one or more specified images, if the
image names or image ARNs are provided. Otherwise, all images in the
account are described.
}
\section{Request syntax}{
\preformatted{svc$describe_images(
  Names = list(
    "string"
  ),
  Arns = list(
    "string"
  ),
  Type = "PUBLIC"|"PRIVATE"|"SHARED",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
