% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_directory_configs}
\alias{appstream_describe_directory_configs}
\title{Retrieves a list that describes one or more specified Directory Config
objects for AppStream 2}
\usage{
appstream_describe_directory_configs(DirectoryNames, MaxResults,
  NextToken)
}
\arguments{
\item{DirectoryNames}{The directory names.}

\item{MaxResults}{The maximum size of each page of results.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}
}
\value{
A list with the following syntax:\preformatted{list(
  DirectoryConfigs = list(
    list(
      DirectoryName = "string",
      OrganizationalUnitDistinguishedNames = list(
        "string"
      ),
      ServiceAccountCredentials = list(
        AccountName = "string",
        AccountPassword = "string"
      ),
      CreatedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes one or more specified Directory Config
objects for AppStream 2.0, if the names for these objects are provided.
Otherwise, all Directory Config objects in the account are described.
These objects include the configuration information required to join
fleets and image builders to Microsoft Active Directory domains.

Although the response syntax in this topic includes the account
password, this password is not returned in the actual response.
}
\section{Request syntax}{
\preformatted{svc$describe_directory_configs(
  DirectoryNames = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
