# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include worklink_service.R
NULL

#' Specifies a domain to be associated to Amazon WorkLink
#'
#' @description
#' Specifies a domain to be associated to Amazon WorkLink.
#'
#' @usage
#' worklink_associate_domain(FleetArn, DomainName, DisplayName,
#'   AcmCertificateArn)
#'
#' @param FleetArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#' @param DomainName &#91;required&#93; The fully qualified domain name (FQDN).
#' @param DisplayName The name to display.
#' @param AcmCertificateArn &#91;required&#93; The ARN of an issued ACM certificate that is valid for the domain being
#' associated.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_domain(
#'   FleetArn = "string",
#'   DomainName = "string",
#'   DisplayName = "string",
#'   AcmCertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_associate_domain
worklink_associate_domain <- function(FleetArn, DomainName, DisplayName = NULL, AcmCertificateArn) {
  op <- new_operation(
    name = "AssociateDomain",
    http_method = "POST",
    http_path = "/associateDomain",
    paginator = list()
  )
  input <- .worklink$associate_domain_input(FleetArn = FleetArn, DomainName = DomainName, DisplayName = DisplayName, AcmCertificateArn = AcmCertificateArn)
  output <- .worklink$associate_domain_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$associate_domain <- worklink_associate_domain

#' Associates a website authorization provider with a specified fleet
#'
#' @description
#' Associates a website authorization provider with a specified fleet. This
#' is used to authorize users against associated websites in the company
#' network.
#'
#' @usage
#' worklink_associate_website_authorization_provider(FleetArn,
#'   AuthorizationProviderType, DomainName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param AuthorizationProviderType &#91;required&#93; The authorization provider type.
#' @param DomainName The domain name of the authorization provider. This applies only to
#' SAML-based authorization providers.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AuthorizationProviderId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_website_authorization_provider(
#'   FleetArn = "string",
#'   AuthorizationProviderType = "SAML",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_associate_website_authorization_provider
worklink_associate_website_authorization_provider <- function(FleetArn, AuthorizationProviderType, DomainName = NULL) {
  op <- new_operation(
    name = "AssociateWebsiteAuthorizationProvider",
    http_method = "POST",
    http_path = "/associateWebsiteAuthorizationProvider",
    paginator = list()
  )
  input <- .worklink$associate_website_authorization_provider_input(FleetArn = FleetArn, AuthorizationProviderType = AuthorizationProviderType, DomainName = DomainName)
  output <- .worklink$associate_website_authorization_provider_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$associate_website_authorization_provider <- worklink_associate_website_authorization_provider

#' Imports the root certificate of a certificate authority (CA) used to
#' obtain TLS certificates used by associated websites within the company
#' network
#'
#' @description
#' Imports the root certificate of a certificate authority (CA) used to
#' obtain TLS certificates used by associated websites within the company
#' network.
#'
#' @usage
#' worklink_associate_website_certificate_authority(FleetArn, Certificate,
#'   DisplayName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param Certificate &#91;required&#93; The root certificate of the CA.
#' @param DisplayName The certificate name to display.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   WebsiteCaId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$associate_website_certificate_authority(
#'   FleetArn = "string",
#'   Certificate = "string",
#'   DisplayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_associate_website_certificate_authority
worklink_associate_website_certificate_authority <- function(FleetArn, Certificate, DisplayName = NULL) {
  op <- new_operation(
    name = "AssociateWebsiteCertificateAuthority",
    http_method = "POST",
    http_path = "/associateWebsiteCertificateAuthority",
    paginator = list()
  )
  input <- .worklink$associate_website_certificate_authority_input(FleetArn = FleetArn, Certificate = Certificate, DisplayName = DisplayName)
  output <- .worklink$associate_website_certificate_authority_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$associate_website_certificate_authority <- worklink_associate_website_certificate_authority

#' Creates a fleet
#'
#' @description
#' Creates a fleet. A fleet consists of resources and the configuration
#' that delivers associated websites to authorized users who download and
#' set up the Amazon WorkLink app.
#'
#' @usage
#' worklink_create_fleet(FleetName, DisplayName,
#'   OptimizeForEndUserLocation, Tags)
#'
#' @param FleetName &#91;required&#93; A unique name for the fleet.
#' @param DisplayName The fleet name to display.
#' @param OptimizeForEndUserLocation The option to optimize for better performance by routing traffic through
#' the closest AWS Region to users, which may be outside of your home
#' Region.
#' @param Tags The tags to add to the resource. A tag is a key-value pair.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_fleet(
#'   FleetName = "string",
#'   DisplayName = "string",
#'   OptimizeForEndUserLocation = TRUE|FALSE,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_create_fleet
worklink_create_fleet <- function(FleetName, DisplayName = NULL, OptimizeForEndUserLocation = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/createFleet",
    paginator = list()
  )
  input <- .worklink$create_fleet_input(FleetName = FleetName, DisplayName = DisplayName, OptimizeForEndUserLocation = OptimizeForEndUserLocation, Tags = Tags)
  output <- .worklink$create_fleet_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$create_fleet <- worklink_create_fleet

#' Deletes a fleet
#'
#' @description
#' Deletes a fleet. Prevents users from accessing previously associated
#' websites.
#'
#' @usage
#' worklink_delete_fleet(FleetArn)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_fleet(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_delete_fleet
worklink_delete_fleet <- function(FleetArn) {
  op <- new_operation(
    name = "DeleteFleet",
    http_method = "POST",
    http_path = "/deleteFleet",
    paginator = list()
  )
  input <- .worklink$delete_fleet_input(FleetArn = FleetArn)
  output <- .worklink$delete_fleet_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$delete_fleet <- worklink_delete_fleet

#' Describes the configuration for delivering audit streams to the customer
#' account
#'
#' @description
#' Describes the configuration for delivering audit streams to the customer
#' account.
#'
#' @usage
#' worklink_describe_audit_stream_configuration(FleetArn)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AuditStreamArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_audit_stream_configuration(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_audit_stream_configuration
worklink_describe_audit_stream_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeAuditStreamConfiguration",
    http_method = "POST",
    http_path = "/describeAuditStreamConfiguration",
    paginator = list()
  )
  input <- .worklink$describe_audit_stream_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_audit_stream_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_audit_stream_configuration <- worklink_describe_audit_stream_configuration

#' Describes the networking configuration to access the internal websites
#' associated with the specified fleet
#'
#' @description
#' Describes the networking configuration to access the internal websites
#' associated with the specified fleet.
#'
#' @usage
#' worklink_describe_company_network_configuration(FleetArn)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   VpcId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_company_network_configuration(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_company_network_configuration
worklink_describe_company_network_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeCompanyNetworkConfiguration",
    http_method = "POST",
    http_path = "/describeCompanyNetworkConfiguration",
    paginator = list()
  )
  input <- .worklink$describe_company_network_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_company_network_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_company_network_configuration <- worklink_describe_company_network_configuration

#' Provides information about a user's device
#'
#' @description
#' Provides information about a user's device.
#'
#' @usage
#' worklink_describe_device(FleetArn, DeviceId)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DeviceId &#91;required&#93; A unique identifier for a registered user's device.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Status = "ACTIVE"|"SIGNED_OUT",
#'   Model = "string",
#'   Manufacturer = "string",
#'   OperatingSystem = "string",
#'   OperatingSystemVersion = "string",
#'   PatchLevel = "string",
#'   FirstAccessedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastAccessedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Username = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_device(
#'   FleetArn = "string",
#'   DeviceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_device
worklink_describe_device <- function(FleetArn, DeviceId) {
  op <- new_operation(
    name = "DescribeDevice",
    http_method = "POST",
    http_path = "/describeDevice",
    paginator = list()
  )
  input <- .worklink$describe_device_input(FleetArn = FleetArn, DeviceId = DeviceId)
  output <- .worklink$describe_device_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_device <- worklink_describe_device

#' Describes the device policy configuration for the specified fleet
#'
#' @description
#' Describes the device policy configuration for the specified fleet.
#'
#' @usage
#' worklink_describe_device_policy_configuration(FleetArn)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DeviceCaCertificate = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_device_policy_configuration(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_device_policy_configuration
worklink_describe_device_policy_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeDevicePolicyConfiguration",
    http_method = "POST",
    http_path = "/describeDevicePolicyConfiguration",
    paginator = list()
  )
  input <- .worklink$describe_device_policy_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_device_policy_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_device_policy_configuration <- worklink_describe_device_policy_configuration

#' Provides information about the domain
#'
#' @description
#' Provides information about the domain.
#'
#' @usage
#' worklink_describe_domain(FleetArn, DomainName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DomainName = "string",
#'   DisplayName = "string",
#'   CreatedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DomainStatus = "PENDING_VALIDATION"|"ASSOCIATING"|"ACTIVE"|"INACTIVE"|"DISASSOCIATING"|"DISASSOCIATED"|"FAILED_TO_ASSOCIATE"|"FAILED_TO_DISASSOCIATE",
#'   AcmCertificateArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_domain(
#'   FleetArn = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_domain
worklink_describe_domain <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/describeDomain",
    paginator = list()
  )
  input <- .worklink$describe_domain_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$describe_domain_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_domain <- worklink_describe_domain

#' Provides basic information for the specified fleet, excluding identity
#' provider, networking, and device configuration details
#'
#' @description
#' Provides basic information for the specified fleet, excluding identity
#' provider, networking, and device configuration details.
#'
#' @usage
#' worklink_describe_fleet_metadata(FleetArn)
#'
#' @param FleetArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CreatedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastUpdatedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   FleetName = "string",
#'   DisplayName = "string",
#'   OptimizeForEndUserLocation = TRUE|FALSE,
#'   CompanyCode = "string",
#'   FleetStatus = "CREATING"|"ACTIVE"|"DELETING"|"DELETED"|"FAILED_TO_CREATE"|"FAILED_TO_DELETE",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleet_metadata(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_fleet_metadata
worklink_describe_fleet_metadata <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeFleetMetadata",
    http_method = "POST",
    http_path = "/describeFleetMetadata",
    paginator = list()
  )
  input <- .worklink$describe_fleet_metadata_input(FleetArn = FleetArn)
  output <- .worklink$describe_fleet_metadata_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_fleet_metadata <- worklink_describe_fleet_metadata

#' Describes the identity provider configuration of the specified fleet
#'
#' @description
#' Describes the identity provider configuration of the specified fleet.
#'
#' @usage
#' worklink_describe_identity_provider_configuration(FleetArn)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IdentityProviderType = "SAML",
#'   ServiceProviderSamlMetadata = "string",
#'   IdentityProviderSamlMetadata = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_identity_provider_configuration(
#'   FleetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_identity_provider_configuration
worklink_describe_identity_provider_configuration <- function(FleetArn) {
  op <- new_operation(
    name = "DescribeIdentityProviderConfiguration",
    http_method = "POST",
    http_path = "/describeIdentityProviderConfiguration",
    paginator = list()
  )
  input <- .worklink$describe_identity_provider_configuration_input(FleetArn = FleetArn)
  output <- .worklink$describe_identity_provider_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_identity_provider_configuration <- worklink_describe_identity_provider_configuration

#' Provides information about the certificate authority
#'
#' @description
#' Provides information about the certificate authority.
#'
#' @usage
#' worklink_describe_website_certificate_authority(FleetArn, WebsiteCaId)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param WebsiteCaId &#91;required&#93; A unique identifier for the certificate authority.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Certificate = "string",
#'   CreatedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DisplayName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_website_certificate_authority(
#'   FleetArn = "string",
#'   WebsiteCaId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_describe_website_certificate_authority
worklink_describe_website_certificate_authority <- function(FleetArn, WebsiteCaId) {
  op <- new_operation(
    name = "DescribeWebsiteCertificateAuthority",
    http_method = "POST",
    http_path = "/describeWebsiteCertificateAuthority",
    paginator = list()
  )
  input <- .worklink$describe_website_certificate_authority_input(FleetArn = FleetArn, WebsiteCaId = WebsiteCaId)
  output <- .worklink$describe_website_certificate_authority_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$describe_website_certificate_authority <- worklink_describe_website_certificate_authority

#' Disassociates a domain from Amazon WorkLink
#'
#' @description
#' Disassociates a domain from Amazon WorkLink. End users lose the ability
#' to access the domain with Amazon WorkLink.
#'
#' @usage
#' worklink_disassociate_domain(FleetArn, DomainName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_domain(
#'   FleetArn = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_disassociate_domain
worklink_disassociate_domain <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "DisassociateDomain",
    http_method = "POST",
    http_path = "/disassociateDomain",
    paginator = list()
  )
  input <- .worklink$disassociate_domain_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$disassociate_domain_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$disassociate_domain <- worklink_disassociate_domain

#' Disassociates a website authorization provider from a specified fleet
#'
#' @description
#' Disassociates a website authorization provider from a specified fleet.
#' After the disassociation, users can't load any associated websites that
#' require this authorization provider.
#'
#' @usage
#' worklink_disassociate_website_authorization_provider(FleetArn,
#'   AuthorizationProviderId)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param AuthorizationProviderId &#91;required&#93; A unique identifier for the authorization provider.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_website_authorization_provider(
#'   FleetArn = "string",
#'   AuthorizationProviderId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_disassociate_website_authorization_provider
worklink_disassociate_website_authorization_provider <- function(FleetArn, AuthorizationProviderId) {
  op <- new_operation(
    name = "DisassociateWebsiteAuthorizationProvider",
    http_method = "POST",
    http_path = "/disassociateWebsiteAuthorizationProvider",
    paginator = list()
  )
  input <- .worklink$disassociate_website_authorization_provider_input(FleetArn = FleetArn, AuthorizationProviderId = AuthorizationProviderId)
  output <- .worklink$disassociate_website_authorization_provider_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$disassociate_website_authorization_provider <- worklink_disassociate_website_authorization_provider

#' Removes a certificate authority (CA)
#'
#' @description
#' Removes a certificate authority (CA).
#'
#' @usage
#' worklink_disassociate_website_certificate_authority(FleetArn,
#'   WebsiteCaId)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param WebsiteCaId &#91;required&#93; A unique identifier for the CA.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_website_certificate_authority(
#'   FleetArn = "string",
#'   WebsiteCaId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_disassociate_website_certificate_authority
worklink_disassociate_website_certificate_authority <- function(FleetArn, WebsiteCaId) {
  op <- new_operation(
    name = "DisassociateWebsiteCertificateAuthority",
    http_method = "POST",
    http_path = "/disassociateWebsiteCertificateAuthority",
    paginator = list()
  )
  input <- .worklink$disassociate_website_certificate_authority_input(FleetArn = FleetArn, WebsiteCaId = WebsiteCaId)
  output <- .worklink$disassociate_website_certificate_authority_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$disassociate_website_certificate_authority <- worklink_disassociate_website_certificate_authority

#' Retrieves a list of devices registered with the specified fleet
#'
#' @description
#' Retrieves a list of devices registered with the specified fleet.
#'
#' @usage
#' worklink_list_devices(FleetArn, NextToken, MaxResults)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Devices = list(
#'     list(
#'       DeviceId = "string",
#'       DeviceStatus = "ACTIVE"|"SIGNED_OUT"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_devices(
#'   FleetArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_list_devices
worklink_list_devices <- function(FleetArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "POST",
    http_path = "/listDevices",
    paginator = list()
  )
  input <- .worklink$list_devices_input(FleetArn = FleetArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_devices_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_devices <- worklink_list_devices

#' Retrieves a list of domains associated to a specified fleet
#'
#' @description
#' Retrieves a list of domains associated to a specified fleet.
#'
#' @usage
#' worklink_list_domains(FleetArn, NextToken, MaxResults)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Domains = list(
#'     list(
#'       DomainName = "string",
#'       DisplayName = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DomainStatus = "PENDING_VALIDATION"|"ASSOCIATING"|"ACTIVE"|"INACTIVE"|"DISASSOCIATING"|"DISASSOCIATED"|"FAILED_TO_ASSOCIATE"|"FAILED_TO_DISASSOCIATE"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_domains(
#'   FleetArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_list_domains
worklink_list_domains <- function(FleetArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/listDomains",
    paginator = list()
  )
  input <- .worklink$list_domains_input(FleetArn = FleetArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_domains_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_domains <- worklink_list_domains

#' Retrieves a list of fleets for the current account and Region
#'
#' @description
#' Retrieves a list of fleets for the current account and Region.
#'
#' @usage
#' worklink_list_fleets(NextToken, MaxResults)
#'
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FleetSummaryList = list(
#'     list(
#'       FleetArn = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       FleetName = "string",
#'       DisplayName = "string",
#'       CompanyCode = "string",
#'       FleetStatus = "CREATING"|"ACTIVE"|"DELETING"|"DELETED"|"FAILED_TO_CREATE"|"FAILED_TO_DELETE",
#'       Tags = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_fleets(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_list_fleets
worklink_list_fleets <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFleets",
    http_method = "POST",
    http_path = "/listFleets",
    paginator = list()
  )
  input <- .worklink$list_fleets_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_fleets_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_fleets <- worklink_list_fleets

#' Retrieves a list of tags for the specified resource
#'
#' @description
#' Retrieves a list of tags for the specified resource.
#'
#' @usage
#' worklink_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_list_tags_for_resource
worklink_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .worklink$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .worklink$list_tags_for_resource_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_tags_for_resource <- worklink_list_tags_for_resource

#' Retrieves a list of website authorization providers associated with a
#' specified fleet
#'
#' @description
#' Retrieves a list of website authorization providers associated with a
#' specified fleet.
#'
#' @usage
#' worklink_list_website_authorization_providers(FleetArn, NextToken,
#'   MaxResults)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum number of results to be included in the next page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   WebsiteAuthorizationProviders = list(
#'     list(
#'       AuthorizationProviderId = "string",
#'       AuthorizationProviderType = "SAML",
#'       DomainName = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_website_authorization_providers(
#'   FleetArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_list_website_authorization_providers
worklink_list_website_authorization_providers <- function(FleetArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWebsiteAuthorizationProviders",
    http_method = "POST",
    http_path = "/listWebsiteAuthorizationProviders",
    paginator = list()
  )
  input <- .worklink$list_website_authorization_providers_input(FleetArn = FleetArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .worklink$list_website_authorization_providers_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_website_authorization_providers <- worklink_list_website_authorization_providers

#' Retrieves a list of certificate authorities added for the current
#' account and Region
#'
#' @description
#' Retrieves a list of certificate authorities added for the current
#' account and Region.
#'
#' @usage
#' worklink_list_website_certificate_authorities(FleetArn, MaxResults,
#'   NextToken)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param MaxResults The maximum number of results to be included in the next page.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   WebsiteCertificateAuthorities = list(
#'     list(
#'       WebsiteCaId = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DisplayName = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_website_certificate_authorities(
#'   FleetArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_list_website_certificate_authorities
worklink_list_website_certificate_authorities <- function(FleetArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListWebsiteCertificateAuthorities",
    http_method = "POST",
    http_path = "/listWebsiteCertificateAuthorities",
    paginator = list()
  )
  input <- .worklink$list_website_certificate_authorities_input(FleetArn = FleetArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .worklink$list_website_certificate_authorities_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$list_website_certificate_authorities <- worklink_list_website_certificate_authorities

#' Moves a domain to ACTIVE status if it was in the INACTIVE status
#'
#' @description
#' Moves a domain to ACTIVE status if it was in the INACTIVE status.
#'
#' @usage
#' worklink_restore_domain_access(FleetArn, DomainName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$restore_domain_access(
#'   FleetArn = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_restore_domain_access
worklink_restore_domain_access <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "RestoreDomainAccess",
    http_method = "POST",
    http_path = "/restoreDomainAccess",
    paginator = list()
  )
  input <- .worklink$restore_domain_access_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$restore_domain_access_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$restore_domain_access <- worklink_restore_domain_access

#' Moves a domain to INACTIVE status if it was in the ACTIVE status
#'
#' @description
#' Moves a domain to INACTIVE status if it was in the ACTIVE status.
#'
#' @usage
#' worklink_revoke_domain_access(FleetArn, DomainName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_domain_access(
#'   FleetArn = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_revoke_domain_access
worklink_revoke_domain_access <- function(FleetArn, DomainName) {
  op <- new_operation(
    name = "RevokeDomainAccess",
    http_method = "POST",
    http_path = "/revokeDomainAccess",
    paginator = list()
  )
  input <- .worklink$revoke_domain_access_input(FleetArn = FleetArn, DomainName = DomainName)
  output <- .worklink$revoke_domain_access_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$revoke_domain_access <- worklink_revoke_domain_access

#' Signs the user out from all of their devices
#'
#' @description
#' Signs the user out from all of their devices. The user can sign in again
#' if they have valid credentials.
#'
#' @usage
#' worklink_sign_out_user(FleetArn, Username)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param Username &#91;required&#93; The name of the user.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$sign_out_user(
#'   FleetArn = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_sign_out_user
worklink_sign_out_user <- function(FleetArn, Username) {
  op <- new_operation(
    name = "SignOutUser",
    http_method = "POST",
    http_path = "/signOutUser",
    paginator = list()
  )
  input <- .worklink$sign_out_user_input(FleetArn = FleetArn, Username = Username)
  output <- .worklink$sign_out_user_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$sign_out_user <- worklink_sign_out_user

#' Adds or overwrites one or more tags for the specified resource, such as
#' a fleet
#'
#' @description
#' Adds or overwrites one or more tags for the specified resource, such as
#' a fleet. Each tag consists of a key and an optional value. If a resource
#' already has a tag with the same key, this operation updates its value.
#'
#' @usage
#' worklink_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#' @param Tags &#91;required&#93; The tags to add to the resource. A tag is a key-value pair.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_tag_resource
worklink_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .worklink$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .worklink$tag_resource_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$tag_resource <- worklink_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' @usage
#' worklink_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the fleet.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_untag_resource
worklink_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .worklink$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .worklink$untag_resource_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$untag_resource <- worklink_untag_resource

#' Updates the audit stream configuration for the fleet
#'
#' @description
#' Updates the audit stream configuration for the fleet.
#'
#' @usage
#' worklink_update_audit_stream_configuration(FleetArn, AuditStreamArn)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param AuditStreamArn The ARN of the Amazon Kinesis data stream that receives the audit
#' events.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_audit_stream_configuration(
#'   FleetArn = "string",
#'   AuditStreamArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_update_audit_stream_configuration
worklink_update_audit_stream_configuration <- function(FleetArn, AuditStreamArn = NULL) {
  op <- new_operation(
    name = "UpdateAuditStreamConfiguration",
    http_method = "POST",
    http_path = "/updateAuditStreamConfiguration",
    paginator = list()
  )
  input <- .worklink$update_audit_stream_configuration_input(FleetArn = FleetArn, AuditStreamArn = AuditStreamArn)
  output <- .worklink$update_audit_stream_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_audit_stream_configuration <- worklink_update_audit_stream_configuration

#' Updates the company network configuration for the fleet
#'
#' @description
#' Updates the company network configuration for the fleet.
#'
#' @usage
#' worklink_update_company_network_configuration(FleetArn, VpcId,
#'   SubnetIds, SecurityGroupIds)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param VpcId &#91;required&#93; The VPC with connectivity to associated websites.
#' @param SubnetIds &#91;required&#93; The subnets used for X-ENI connections from Amazon WorkLink rendering
#' containers.
#' @param SecurityGroupIds &#91;required&#93; The security groups associated with access to the provided subnets.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_company_network_configuration(
#'   FleetArn = "string",
#'   VpcId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_update_company_network_configuration
worklink_update_company_network_configuration <- function(FleetArn, VpcId, SubnetIds, SecurityGroupIds) {
  op <- new_operation(
    name = "UpdateCompanyNetworkConfiguration",
    http_method = "POST",
    http_path = "/updateCompanyNetworkConfiguration",
    paginator = list()
  )
  input <- .worklink$update_company_network_configuration_input(FleetArn = FleetArn, VpcId = VpcId, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds)
  output <- .worklink$update_company_network_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_company_network_configuration <- worklink_update_company_network_configuration

#' Updates the device policy configuration for the fleet
#'
#' @description
#' Updates the device policy configuration for the fleet.
#'
#' @usage
#' worklink_update_device_policy_configuration(FleetArn,
#'   DeviceCaCertificate)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DeviceCaCertificate The certificate chain, including intermediate certificates and the root
#' certificate authority certificate used to issue device certificates.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_device_policy_configuration(
#'   FleetArn = "string",
#'   DeviceCaCertificate = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_update_device_policy_configuration
worklink_update_device_policy_configuration <- function(FleetArn, DeviceCaCertificate = NULL) {
  op <- new_operation(
    name = "UpdateDevicePolicyConfiguration",
    http_method = "POST",
    http_path = "/updateDevicePolicyConfiguration",
    paginator = list()
  )
  input <- .worklink$update_device_policy_configuration_input(FleetArn = FleetArn, DeviceCaCertificate = DeviceCaCertificate)
  output <- .worklink$update_device_policy_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_device_policy_configuration <- worklink_update_device_policy_configuration

#' Updates domain metadata, such as DisplayName
#'
#' @description
#' Updates domain metadata, such as DisplayName.
#'
#' @usage
#' worklink_update_domain_metadata(FleetArn, DomainName, DisplayName)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DomainName &#91;required&#93; The name of the domain.
#' @param DisplayName The name to display.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_metadata(
#'   FleetArn = "string",
#'   DomainName = "string",
#'   DisplayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_update_domain_metadata
worklink_update_domain_metadata <- function(FleetArn, DomainName, DisplayName = NULL) {
  op <- new_operation(
    name = "UpdateDomainMetadata",
    http_method = "POST",
    http_path = "/updateDomainMetadata",
    paginator = list()
  )
  input <- .worklink$update_domain_metadata_input(FleetArn = FleetArn, DomainName = DomainName, DisplayName = DisplayName)
  output <- .worklink$update_domain_metadata_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_domain_metadata <- worklink_update_domain_metadata

#' Updates fleet metadata, such as DisplayName
#'
#' @description
#' Updates fleet metadata, such as DisplayName.
#'
#' @usage
#' worklink_update_fleet_metadata(FleetArn, DisplayName,
#'   OptimizeForEndUserLocation)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param DisplayName The fleet name to display. The existing DisplayName is unset if null is
#' passed.
#' @param OptimizeForEndUserLocation The option to optimize for better performance by routing traffic through
#' the closest AWS Region to users, which may be outside of your home
#' Region.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_fleet_metadata(
#'   FleetArn = "string",
#'   DisplayName = "string",
#'   OptimizeForEndUserLocation = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_update_fleet_metadata
worklink_update_fleet_metadata <- function(FleetArn, DisplayName = NULL, OptimizeForEndUserLocation = NULL) {
  op <- new_operation(
    name = "UpdateFleetMetadata",
    http_method = "POST",
    http_path = "/UpdateFleetMetadata",
    paginator = list()
  )
  input <- .worklink$update_fleet_metadata_input(FleetArn = FleetArn, DisplayName = DisplayName, OptimizeForEndUserLocation = OptimizeForEndUserLocation)
  output <- .worklink$update_fleet_metadata_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_fleet_metadata <- worklink_update_fleet_metadata

#' Updates the identity provider configuration for the fleet
#'
#' @description
#' Updates the identity provider configuration for the fleet.
#'
#' @usage
#' worklink_update_identity_provider_configuration(FleetArn,
#'   IdentityProviderType, IdentityProviderSamlMetadata)
#'
#' @param FleetArn &#91;required&#93; The ARN of the fleet.
#' @param IdentityProviderType &#91;required&#93; The type of identity provider.
#' @param IdentityProviderSamlMetadata The SAML metadata document provided by the customer’s identity provider.
#' The existing IdentityProviderSamlMetadata is unset if null is passed.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_identity_provider_configuration(
#'   FleetArn = "string",
#'   IdentityProviderType = "SAML",
#'   IdentityProviderSamlMetadata = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname worklink_update_identity_provider_configuration
worklink_update_identity_provider_configuration <- function(FleetArn, IdentityProviderType, IdentityProviderSamlMetadata = NULL) {
  op <- new_operation(
    name = "UpdateIdentityProviderConfiguration",
    http_method = "POST",
    http_path = "/updateIdentityProviderConfiguration",
    paginator = list()
  )
  input <- .worklink$update_identity_provider_configuration_input(FleetArn = FleetArn, IdentityProviderType = IdentityProviderType, IdentityProviderSamlMetadata = IdentityProviderSamlMetadata)
  output <- .worklink$update_identity_provider_configuration_output()
  config <- get_config()
  svc <- .worklink$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.worklink$operations$update_identity_provider_configuration <- worklink_update_identity_provider_configuration
