% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_evaluate_pull_request_approval_rules}
\alias{codecommit_evaluate_pull_request_approval_rules}
\title{Evaluates whether a pull request has met all the conditions specified in
its associated approval rules}
\usage{
codecommit_evaluate_pull_request_approval_rules(pullRequestId,
  revisionId)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request you want to evaluate.}

\item{revisionId}{[required] The system-generated ID for the pull request revision. To retrieve the
most recent revision ID for a pull request, use
\code{\link[=codecommit_get_pull_request]{get_pull_request}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  evaluation = list(
    approved = TRUE|FALSE,
    overridden = TRUE|FALSE,
    approvalRulesSatisfied = list(
      "string"
    ),
    approvalRulesNotSatisfied = list(
      "string"
    )
  )
)
}
}
\description{
Evaluates whether a pull request has met all the conditions specified in
its associated approval rules.
}
\section{Request syntax}{
\preformatted{svc$evaluate_pull_request_approval_rules(
  pullRequestId = "string",
  revisionId = "string"
)
}
}

\keyword{internal}
